<h2>Why is this an issue?</h2>
<p>Testing equality or nullness with PHPUnit’s <code>assertTrue()</code> or <code>assertFalse()</code> should be simplified to the corresponding
dedicated assertion.</p>
<h3>Noncompliant code example</h3>

```php
assertTrue($a === $b);
assertTrue($a == $b);
assertTrue($a === null);
assertTrue($a !== null);
assertTrue($a !== $b);
assertTrue($a != $b);
assertFalse($a === $b);
assertFalse($a == $b);
assertTrue($a == true);
assertTrue($a == false);
```
<h3>Compliant solution</h3>

```php
assertEquals($a, $b);
assertSame($a, $b);
assertNull($a);
assertNotNull($a);
assertNotEquals($a, $b);
assertNotSame($a, $b);
assertNotEquals($a, $b);
assertNotSame($a, $b);
assertTrue($a);
assertFalse($a);
```