<h2>Why is this an issue?</h2>
<p>Errors should not be created without being thrown because they can confuse and make it difficult to debug code. When an error is thrown, it means
that something unexpected has happened, and the program cannot continue executing as expected. By creating an error without throwing it, it may appear
as if everything is working correctly, but in reality, an underlying issue must be addressed.</p>

```ts
if (x < 0) {
  new Error("x must be nonnegative"); // Noncompliant: Creating an error without throwing it
}
```
<p>You should make sure to always throw an error that you create using the <code>throw</code> keyword.</p>

```ts
if (x < 0) {
  throw new Error("x must be nonnegative");
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Error">Error</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/throw">throw</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Control_flow_and_error_handling">Control flow and error
  handling</a> </li>
</ul>