/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

@Check(id="cqse-cross-client-database-access", languages={ELanguage.ABAP})
public class CrossClientDatabaseAccessCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List keywordTokens = this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED).stream().filter(token -> token.getType().isKeyword()).collect(Collectors.toList());
        Iterator iterator = TokenStreamUtils.firstTokenOfTypeSequences(keywordTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.CLIENT, ETokenType.SPECIFIED}).iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.buildFinding("Cross-client database access (usage of `CLIENT SPECIFIED`)", this.buildLocation().betweenTokens((IToken)keywordTokens.get(i), (IToken)keywordTokens.get(i + 1))).createAndStore();
        }
    }
}

