/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.markup.MarkupUtils;

public abstract class HashCodeAndEqualsCheckBase
extends CheckImplementationBase {
    protected abstract String getHashCodeName();

    protected abstract String getEqualsName();

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        ShallowEntity equalsEntity = this.getMethodEntity(entity, this.getEqualsName(), 1);
        ShallowEntity hashCodeEntity = this.getMethodEntity(entity, this.getHashCodeName(), 0);
        String formattedHashcodeName = MarkupUtils.formatAsSourceCode((String)(this.getHashCodeName() + "()"));
        String formattedEqualsName = MarkupUtils.formatAsSourceCode((String)(this.getEqualsName() + "()"));
        String formattedEntityName = MarkupUtils.formatAsSourceCode((String)entity.getName());
        if (equalsEntity != null && hashCodeEntity == null) {
            this.buildFinding(formattedEqualsName + " but not " + formattedHashcodeName + " implemented in class " + formattedEntityName, this.buildLocation().forEntityFirstLine(equalsEntity)).createAndStore();
        } else if (equalsEntity == null && hashCodeEntity != null && this.createFindingForMissingEquals(entity)) {
            this.buildFinding(formattedHashcodeName + " but not " + formattedEqualsName + " implemented in class " + formattedEntityName, this.buildLocation().forEntityFirstLine(hashCodeEntity)).createAndStore();
        }
    }

    protected String getMethodSelector(String name) {
        return "METHOD[subtype('method') and name-matches('" + name + "')]";
    }

    protected boolean createFindingForMissingEquals(ShallowEntity entity) {
        return true;
    }

    private ShallowEntity getMethodEntity(ShallowEntity type, String name, int parameterCount) throws CheckException {
        String methodSelector = this.getMethodSelector(name);
        for (ShallowEntity methodEntity : HashCodeAndEqualsCheckBase.select((ShallowEntity)type, (String)methodSelector)) {
            if (ShallowParsingUtils.extractParameterNameTokens((ShallowEntity)methodEntity).size() != parameterCount) continue;
            return methodEntity;
        }
        return null;
    }
}

