/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.MethodCallMatchers;
import eu.cqse.check.framework.util.clike.HardcodedParameterEvaluator;
import java.util.List;

@Check(id="java:S6301", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class AndroidMobileDatabaseEncryptionKeysCheck
extends CheckImplementationBase {
    private static final MethodCallMatchers METHOD_CALL_MATCHERS = MethodCallMatchers.combine((JavaMethodCallMatcher[])new JavaMethodCallMatcher[]{JavaMethodCallMatcher.create().onTypes(new String[]{"net.sqlcipher.database.SQLiteDatabase"}).constructors().withParameterMinCount(1).withTag((Object)"password"), JavaMethodCallMatcher.create().onTypes(new String[]{"net.sqlcipher.database.SQLiteDatabase"}).withTargetMethodNames(new String[]{"changePassword", "openDatabase", "openOrCreateDatabase", "create"}).withParameterMinCount(1).withTag((Object)"password"), JavaMethodCallMatcher.create().onTypes(new String[]{"io.realm.RealmConfiguration$Builder"}).withTargetMethodNames(new String[]{"encryptionKey"}).withParameterCount(1).withTag((Object)"encryptionKey")});
    private static final String FINDING_MESSAGE = "The `%s` parameter should not be hardcoded";

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (JavaMethodCallMatcher.MethodCall methodCall : METHOD_CALL_MATCHERS.find(this.context, typeResolver)) {
            List targetParameterTokens;
            List parameters = LanguageFeatureParser.JAVA.getMethodArguments(methodCall.entity(), methodCall.token().getOffset());
            String parameterName = (String)methodCall.tag();
            List list = targetParameterTokens = parameters.size() > 1 ? (List)parameters.get(1) : (List)parameters.getFirst();
            HardcodedParameterEvaluator parameterEvaluator = new HardcodedParameterEvaluator(methodCall.entity(), targetParameterTokens, this.context.getTypeResolution(this.getCodeViewOption()));
            if (!parameterEvaluator.isHardcodedExpression()) continue;
            this.buildFinding(FINDING_MESSAGE.formatted(parameterName), this.buildLocation().forToken(methodCall.token())).createAndStore();
        }
    }
}

