/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.JavaStringValueResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;

@Check(id="java:S6816", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NullableInjectedFieldsHaveDefaultValueCheck
extends CheckImplementationBase {
    private static final String MESSAGE_FOR_FIELDS = "Provide a default null value for this field";
    private static final String MESSAGE_FOR_PARAMETERS = "Provide a default null value for this parameter";
    private static final String NULLABLE = "Nullable";
    private static final int VALUE_GROUP = 0;
    private static final TokenPattern VALUE_ANNOTATION_PATTERN = TokenPattern.of().sequence(new Object[]{ETokenType.AT_OPERATOR}).tokenTypeAndText(ETokenType.IDENTIFIER, "Value").sequence(new Object[]{ETokenType.LPAREN}).optional(new Object[]{TokenPattern.of().tokenTypeAndText(ETokenType.IDENTIFIER, "value").sequence(new Object[]{ETokenType.EQ})}).skipUntil(new Object[]{ETokenType.RPAREN}).group(0);
    private JavaStringValueResolver javaStringValueResolver;

    public void execute() throws CheckException {
        this.javaStringValueResolver = new JavaStringValueResolver(this.context.getRootEntity(this.getCodeViewOption()));
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.ATTRIBUTE).forEach(this::checkAttributeForValueAnnotationWithoutDefaultValue);
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD).forEach(this::checkMethodForValueAnnotationsWithoutDefaultValue);
    }

    private void checkAttributeForValueAnnotationWithoutDefaultValue(ShallowEntity attribute) {
        boolean isNullable = false;
        ShallowEntity valueAnnotationWithoutDefaultValue = null;
        for (ShallowEntity annotation : LanguageFeatureParser.JAVA.getAnnotations(attribute)) {
            if (this.isValueAnnotationWithoutDefaultValue((List<IToken>)annotation.ownStartTokens())) {
                valueAnnotationWithoutDefaultValue = annotation;
            }
            if (annotation.getName() == null || !annotation.getName().contains(NULLABLE)) continue;
            isNullable = true;
        }
        if (valueAnnotationWithoutDefaultValue != null && isNullable) {
            this.buildFinding(MESSAGE_FOR_FIELDS, this.buildLocation().forEntity(valueAnnotationWithoutDefaultValue)).createAndStore();
        }
    }

    private void checkMethodForValueAnnotationsWithoutDefaultValue(ShallowEntity method) {
        if (LanguageFeatureParser.JAVA.isSetterMethod(method)) {
            this.checkSetter(method);
        }
        for (List parameterTokens : LanguageFeatureParser.JAVA.getSplitParameterTokens(method)) {
            this.checkMethodParameter(parameterTokens);
        }
    }

    private void checkSetter(ShallowEntity setter) {
        boolean parameterIsNullable = LanguageFeatureParser.JAVA.extractAnnotationsFromParameter(LanguageFeatureParser.JAVA.getParameterTokens(setter)).stream().anyMatch(annotation -> TokenStreamTextUtils.contains((List)annotation, (String)NULLABLE));
        if (!parameterIsNullable) {
            return;
        }
        LanguageFeatureParser.JAVA.getAnnotations(setter).stream().filter(annotation -> this.isValueAnnotationWithoutDefaultValue((List<IToken>)annotation.ownStartTokens())).findFirst().ifPresent(annotation -> this.buildFinding(MESSAGE_FOR_PARAMETERS, this.buildLocation().forEntity(annotation)).createAndStore());
    }

    private void checkMethodParameter(List<IToken> parameterTokens) {
        boolean isNullable = false;
        List valueAnnotationWithoutDefaultValue = null;
        for (List annotation : LanguageFeatureParser.JAVA.extractAnnotationsFromParameter(parameterTokens)) {
            if (this.isValueAnnotationWithoutDefaultValue(annotation)) {
                valueAnnotationWithoutDefaultValue = annotation;
            }
            if (!TokenStreamTextUtils.contains((List)annotation, (String)NULLABLE)) continue;
            isNullable = true;
        }
        if (valueAnnotationWithoutDefaultValue != null && isNullable) {
            this.buildFinding(MESSAGE_FOR_PARAMETERS, this.buildLocation().forTokens(valueAnnotationWithoutDefaultValue)).createAndStore();
        }
    }

    private boolean isValueAnnotationWithoutDefaultValue(List<IToken> annotationTokens) {
        TokenPatternMatch match = VALUE_ANNOTATION_PATTERN.findFirstMatch(annotationTokens);
        if (match == null) {
            return false;
        }
        List parameterValue = match.groupTokens(0);
        return this.javaStringValueResolver.resolveStringExpression(parameterValue).filter(text -> !NullableInjectedFieldsHaveDefaultValueCheck.hasDefaultValue(text)).isPresent();
    }

    private static boolean hasDefaultValue(String value) {
        String argument = value.strip();
        if (argument.startsWith("${") && argument.endsWith("}")) {
            return argument.contains(":");
        }
        return true;
    }
}

