/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.matlab;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowData;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0034", languages={ELanguage.SIMULINK})
public class SimulinkMatlabFunctionBlockInOutPutSettingsCheck
extends CheckImplementationBase {
    private static final String PARAM_FUNCTION_BLOCK_PORT_COMPLEXITY = "props.complexity";
    private static final String VALUE_FUNCTION_BLOCK_PORT_COMPLEXITY = "SF_COMPLEX_INHERITED";
    private static final String PARAM_FUNCTION_BLOCK_PORT_SIZE = "props.array.size";
    private static final String VALUE_FUNCTION_BLOCK_PORT_SIZE = "-1";
    private static final String PARAM_FUNCTION_BLOCK_PORT_DATATYPE = "dataType";
    private static final String VALUE_FUNCTION_BLOCK_PORT_DATATYPE = "Inherit: Same as Simulink";
    private static final String PARAM_FUNCTION_BLOCK_PORT_SCOPE = "scope";
    private static final String VALUE_FUNCTION_BLOCK_PORT_INPUT_SCOPE = "INPUT_DATA";
    private static final String VALUE_FUNCTION_BLOCK_PORT_OUTPUT_SCOPE = "OUTPUT_DATA";
    private static final FindingPropertyList RECOMMENDED_ACTION_COMPLEXITY = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the port complexity from `Inherited` to either `on` or `off");
    private static final FindingPropertyList RECOMMENDED_ACTION_DATATYPE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the port data type to something other than `Inherit: Same as Simulink`");
    private static final FindingPropertyList RECOMMENDED_ACTION_SIZE = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the port size to something other than `-1` (inherit).");

    public void execute() {
        Optional optionalModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalModel.isEmpty()) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)((SimulinkBlock)optionalModel.get()), (boolean)false, (boolean)false)) {
            if (!StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)block)) continue;
            UnmodifiableSet functionBlockPorts = ((StateflowBlock)block).getChart().getData();
            for (StateflowData functionBlockPort : functionBlockPorts) {
                this.checkInOutSettings(block, functionBlockPort);
            }
        }
    }

    private void checkInOutSettings(SimulinkBlock block, StateflowData functionBlockPort) {
        String portType = "Port";
        if (SimulinkMatlabFunctionBlockInOutPutSettingsCheck.isInputPort(functionBlockPort)) {
            portType = "Input port";
        } else if (SimulinkMatlabFunctionBlockInOutPutSettingsCheck.isOutputPort(functionBlockPort)) {
            portType = "Output port";
        }
        if (SimulinkMatlabFunctionBlockInOutPutSettingsCheck.inOutputPortHasInheritedComplexity(functionBlockPort)) {
            this.buildFinding(MessageFormat.format("{0}: {1} has value for parameter Complexity as an inherited type", portType, MarkupUtils.formatAsSourceCode((String)functionBlockPort.getName())), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_COMPLEXITY).createAndStore();
        }
        if (SimulinkMatlabFunctionBlockInOutPutSettingsCheck.inOutputPortHasInheritedDataType(functionBlockPort)) {
            this.buildFinding(MessageFormat.format("{0}: {1} has value for parameter Data Type as an inherited type", portType, MarkupUtils.formatAsSourceCode((String)functionBlockPort.getName())), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_DATATYPE).createAndStore();
        }
        if (SimulinkMatlabFunctionBlockInOutPutSettingsCheck.inOutputPortHasInheritedSize(functionBlockPort)) {
            this.buildFinding(MessageFormat.format("{0}: {1} has value for parameter Size as an inherited type", portType, MarkupUtils.formatAsSourceCode((String)functionBlockPort.getName())), (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION_SIZE).createAndStore();
        }
    }

    private static boolean inOutputPortHasInheritedComplexity(StateflowData functionBlockPort) {
        String complexity = functionBlockPort.getParameter(PARAM_FUNCTION_BLOCK_PORT_COMPLEXITY);
        return !StringUtils.isEmpty((String)complexity) && complexity.equals(VALUE_FUNCTION_BLOCK_PORT_COMPLEXITY);
    }

    private static boolean inOutputPortHasInheritedDataType(StateflowData functionBlockPort) {
        String dataType = functionBlockPort.getParameter(PARAM_FUNCTION_BLOCK_PORT_DATATYPE);
        return !StringUtils.isEmpty((String)dataType) && dataType.equals(VALUE_FUNCTION_BLOCK_PORT_DATATYPE);
    }

    private static boolean inOutputPortHasInheritedSize(StateflowData functionBlockPort) {
        String size = functionBlockPort.getParameter(PARAM_FUNCTION_BLOCK_PORT_SIZE);
        return !StringUtils.isEmpty((String)size) && size.equals(VALUE_FUNCTION_BLOCK_PORT_SIZE);
    }

    private static boolean isInputPort(StateflowData functionBlockPort) {
        String scope = functionBlockPort.getParameter(PARAM_FUNCTION_BLOCK_PORT_SCOPE);
        return !StringUtils.isEmpty((String)scope) && scope.equals(VALUE_FUNCTION_BLOCK_PORT_INPUT_SCOPE);
    }

    private static boolean isOutputPort(StateflowData functionBlockPort) {
        String scope = functionBlockPort.getParameter(PARAM_FUNCTION_BLOCK_PORT_SCOPE);
        return !StringUtils.isEmpty((String)scope) && scope.equals(VALUE_FUNCTION_BLOCK_PORT_OUTPUT_SCOPE);
    }
}

