/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.naming_conventions.SimulinkNameLengthCheckUtils;
import java.util.Collections;
import java.util.Optional;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0243", languages={ELanguage.SIMULINK})
public class SimulinkSubsystemNameLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum length of subsystem names", description="The maximum number of characters for names of subsystems.")
    private int maximumLength = 40;

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        SimulinkModel model = (SimulinkModel)optionalSimulinkModel.get();
        for (SimulinkBlock block : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Collections.singleton("SubSystem"), (boolean)false, (boolean)false)) {
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, 0, this.maximumLength, block.getName(), "Subsystem", this.buildLocation().forSimulinkBlock(block));
        }
    }
}

