/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    private static final String UNKNOWN = "unknown";
    private final @Nullable Class<? extends Annotation> annotationType;
    final String displayName;
    final boolean validated;

    public AnnotationAttributes() {
        this.annotationType = null;
        this.displayName = UNKNOWN;
        this.validated = false;
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
        this.annotationType = null;
        this.displayName = UNKNOWN;
        this.validated = false;
    }

    public AnnotationAttributes(Map<String, @Nullable Object> map) {
        super(map);
        this.annotationType = null;
        this.displayName = UNKNOWN;
        this.validated = false;
    }

    public AnnotationAttributes(AnnotationAttributes other) {
        super(other);
        this.annotationType = other.annotationType;
        this.displayName = other.displayName;
        this.validated = other.validated;
    }

    public AnnotationAttributes(Class<? extends Annotation> annotationType) {
        this(annotationType, false);
    }

    AnnotationAttributes(Class<? extends Annotation> annotationType, boolean validated) {
        Assert.notNull(annotationType, "'annotationType' must not be null");
        this.annotationType = annotationType;
        this.displayName = annotationType.getName();
        this.validated = validated;
    }

    public AnnotationAttributes(String annotationType, @Nullable ClassLoader classLoader) {
        Assert.notNull((Object)annotationType, "'annotationType' must not be null");
        this.annotationType = AnnotationAttributes.getAnnotationType(annotationType, classLoader);
        this.displayName = annotationType;
        this.validated = false;
    }

    private static @Nullable Class<? extends Annotation> getAnnotationType(String annotationType, @Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            try {
                return classLoader.loadClass(annotationType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public @Nullable Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public String getString(String attributeName) {
        return this.getRequiredAttribute(attributeName, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.getRequiredAttribute(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.getRequiredAttribute(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.getRequiredAttribute(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes.class);
    }

    public <A extends Annotation> A getAnnotation(String attributeName, Class<A> annotationType) {
        return (A)((Annotation)this.getRequiredAttribute(attributeName, annotationType));
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes[].class);
    }

    public <A extends Annotation> A[] getAnnotationArray(String attributeName, Class<A> annotationType) {
        return (Annotation[])this.getRequiredAttribute(attributeName, (Class)annotationType.arrayType());
    }

    private <T> T getRequiredAttribute(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "'attributeName' must not be null or empty");
        Object value = this.get(attributeName);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Attribute '%s' not found in attributes for annotation [%s]", attributeName, this.displayName));
        }
        if (value instanceof Throwable) {
            Throwable throwable = (Throwable)value;
            throw new IllegalArgumentException(String.format("Attribute '%s' for annotation [%s] was not resolvable due to exception [%s]", attributeName, this.displayName, value), throwable);
        }
        if (!expectedType.isInstance(value) && expectedType.isArray() && ((Class)expectedType.componentType()).isInstance(value)) {
            Object array = Array.newInstance(expectedType.componentType(), 1);
            Array.set(array, 0, value);
            value = array;
        }
        if (!expectedType.isInstance(value)) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is of type %s, but %s was expected in attributes for annotation [%s]", attributeName, value.getClass().getSimpleName(), expectedType.getSimpleName(), this.displayName));
        }
        return (T)value;
    }

    @Override
    public String toString() {
        Iterator<Map.Entry<K, @Nullable V>> entries = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        while (entries.hasNext()) {
            Map.Entry<K, @Nullable V> entry = entries.next();
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append(this.valueToString(entry.getValue()));
            if (!entries.hasNext()) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    private String valueToString(@Nullable Object value) {
        if (value == this) {
            return "(this Map)";
        }
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            return "[" + StringUtils.arrayToDelimitedString(objects, ", ") + "]";
        }
        return String.valueOf(value);
    }

    public static @Nullable AnnotationAttributes fromMap(@Nullable Map<String, @Nullable Object> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof AnnotationAttributes) {
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)map;
            return annotationAttributes;
        }
        return new AnnotationAttributes(map);
    }
}

