/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.SwiftPlatformConditions;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SwiftCompilerControlConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @NonNull @Unmodifiable Map<String, Set<Object>> platformConditions;
    private final @NonNull @Unmodifiable Set<String> customFlags;

    private SwiftCompilerControlConfig(@NonNull Map<String, Set<Object>> platformConditions, @NonNull Set<String> customFlags) {
        Preconditions.checkNotNull(platformConditions);
        Preconditions.checkNotNull(customFlags);
        this.platformConditions = platformConditions;
        this.customFlags = customFlags;
    }

    @Contract(value=" -> new")
    public static @NonNull SwiftCompilerControlConfig emptyConfig() {
        return new SwiftCompilerControlConfig(Collections.emptyMap(), Collections.emptySet());
    }

    @Contract(value="_, _ -> new")
    public static @NonNull SwiftCompilerControlConfig fromStringOptions(@Nullable String platformConditions, @Nullable String customFlags) {
        Map<String, Set<Object>> conditions = Collections.emptyMap();
        try {
            conditions = SwiftPlatformConditions.parseConfig(platformConditions);
        }
        catch (Exception e) {
            LOGGER.error("Swift platform conditions configuration: Parsing failed: {}. Continuing anyway, but processing will be incomplete.", (Object)e.getMessage(), (Object)e);
        }
        Set<String> flags = Collections.emptySet();
        try {
            flags = SwiftCompilerControlConfig.parseCustomFlags(customFlags);
        }
        catch (Exception e) {
            LOGGER.error("Swift custom conditional compilation flags configuration: Parsing failed: {}. Continuing anyway, but processing will be incomplete.", (Object)e.getMessage(), (Object)e);
        }
        return new SwiftCompilerControlConfig(conditions, flags);
    }

    @Contract(value="_ -> new")
    private static @NonNull Set<String> parseCustomFlags(@Nullable String unparsedCustomFlags) {
        if (StringUtils.isEmpty((String)unparsedCustomFlags)) {
            return Collections.emptySet();
        }
        List<String> splitFlags = StringUtils.splitToList((String)unparsedCustomFlags, (String)"[,\n]").stream().filter(Predicate.not(StringUtils::isEmpty)).map(String::trim).toList();
        return new HashSet<String>(splitFlags);
    }

    public @NonNull @Unmodifiable Set<Object> getPlatformConditionValues(@NonNull String conditionName) {
        return this.platformConditions.getOrDefault(conditionName, Collections.emptySet());
    }

    public boolean isCustomFlagEnabled(@NonNull String flagName) {
        return this.customFlags.contains(flagName);
    }

    public int getNumberOfCustomFlags() {
        return this.customFlags.size();
    }

    public int getNumberOfPlatformConditions() {
        return this.platformConditions.size();
    }
}

