/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.abap_cds;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.abap_cds.AbapCdsShallowParser;
import java.util.EnumMap;
import java.util.List;
import java.util.Stack;
import org.conqat.lib.commons.collections.CollectionUtils;

class SkipToSemicolonOrEofRecognizer
extends RecognizerBase<AbapCdsShallowParser.EAbapCdsParserStates> {
    private final EnumMap<ETokenType, ETokenType> nestingMap;

    public SkipToSemicolonOrEofRecognizer(List<ETokenType> openingTokens, List<ETokenType> closingTokens) {
        this.nestingMap = new EnumMap(CollectionUtils.zipAsMap(openingTokens, closingTokens));
    }

    @Override
    protected int matchesLocally(ParserState<AbapCdsShallowParser.EAbapCdsParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (startOffset == tokens.size()) {
            return startOffset;
        }
        Stack<ETokenType> expectedTokens = new Stack<ETokenType>();
        for (int offset = startOffset; offset < tokens.size(); ++offset) {
            ETokenType type = tokens.get(offset).getType();
            if (!expectedTokens.isEmpty() && expectedTokens.peek() == type) {
                expectedTokens.pop();
                continue;
            }
            ETokenType closing = this.nestingMap.get(type);
            if (closing != null) {
                expectedTokens.push(closing);
                continue;
            }
            if (!expectedTokens.isEmpty() || tokens.get(offset).getType() != ETokenType.SEMICOLON) continue;
            return offset + 1;
        }
        if (!tokens.isEmpty() && expectedTokens.isEmpty()) {
            return tokens.size();
        }
        return -1;
    }
}

