/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ZipFileUtils {
    public static final int CHAR_CHUNK_SIZE = (int)ByteUnit.MEBIBYTES.toBytes(1L);

    public static byte[] readZipEntryContent(ZipFile zipFile, String entryName) throws IOException {
        ZipArchiveEntry entry = zipFile.getEntry(entryName);
        if (entry == null) {
            throw new IOException("Entry " + entryName + " does not exist in " + zipFile.getName());
        }
        int size = (int)entry.getSize();
        if (size < 0) {
            throw new IOException("Size for entry " + entryName + " not stored in ZIP file " + zipFile.getName());
        }
        byte[] content = new byte[size];
        try (InputStream in = zipFile.getInputStream(entry);){
            FileSystemUtils.safeRead(in, content);
            byte[] byArray = content;
            return byArray;
        }
    }

    public static String extractEntryAsString(ZipArchiveInputStream zis, String entryName) throws IOException {
        return ZipFileUtils.extractEntryAsString(zis, (String fileName) -> fileName.equals(entryName));
    }

    public static String extractEntryAsString(ZipArchiveInputStream zis, Predicate<String> fileNamePredicate) throws IOException {
        ZipArchiveEntry entry;
        while ((entry = zis.getNextEntry()) != null) {
            if (!fileNamePredicate.test(entry.getName())) continue;
            byte[] content = FileSystemUtils.readStreamBinary((InputStream)zis);
            return StringUtils.bytesToString(content);
        }
        return null;
    }

    public static void writeZipEntry(ZipArchiveOutputStream zos, String entryName, CharSequence content) throws IOException {
        zos.putArchiveEntry(new ZipArchiveEntry(entryName));
        int beginningOfChunk = 0;
        int endOfContent = content.length();
        while (beginningOfChunk < endOfContent) {
            int endOfChunk = Math.min(beginningOfChunk + CHAR_CHUNK_SIZE, endOfContent);
            CharBuffer contentChunk = CharBuffer.wrap(content, beginningOfChunk, endOfChunk);
            ByteBuffer encodedChunk = StandardCharsets.UTF_8.encode(contentChunk);
            zos.write(encodedChunk.array(), encodedChunk.position(), encodedChunk.limit());
            beginningOfChunk = endOfChunk;
        }
        zos.closeArchiveEntry();
    }

    private ZipFileUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

