/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture.dependency;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.dependencies.DependencyListIndex;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/dependencies/{uniformPath: .*}")
public class ElementDependencyService
extends ApiBase {
    public static final String INVERSE_PARAMETER_NAME = "inverse";
    private static final String INVERSE_PARAMETER_DESCRIPTION = "If this is set to true, the inverse dependencies on the file identified by the uniform path are returned. This does not work in combination with the types option and will result in an exception.";

    @GET
    @Operation(summary="Get dependencies", description="Returns a list of dependencies for an element.", tags={"Architecture"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<DependencyWithOccurrenceLocation> getDependenciesWithOccurrenceLocation(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="If this is set to true, the inverse dependencies on the file identified by the uniform path are returned. This does not work in combination with the types option and will result in an exception.") @QueryParam(value="inverse") boolean inverse) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TypeDependencyIndex typeDependencyIndex = this.openProjectIndex(TypeDependencyIndex.class, historyAccessOption);
        DependencyListIndex pathDependencyIndex = this.openProjectIndex(DependencyListIndex.class, "dependencies", historyAccessOption);
        return this.getDependenciesWithOccurrenceLocation(uniformPath, inverse, typeDependencyIndex, pathDependencyIndex, historyAccessOption);
    }

    private List<DependencyWithOccurrenceLocation> getDependenciesWithOccurrenceLocation(UniformPath uniformPath, boolean inverse, TypeDependencyIndex typeDependencyIndex, DependencyListIndex pathDependencyIndex, HistoryAccessOption historyAccessOption) throws StorageException {
        if (!this.projectIndexExists("types")) {
            return Collections.emptyList();
        }
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyAccessOption);
        DependencyListIndex incomingDependencyIndex = this.openProjectIndex(DependencyListIndex.class, "inverse-dependencies", historyAccessOption);
        return ElementDependencyService.getDependenciesWithOccurrenceLocation(uniformPath, inverse, typeDependencyIndex, pathDependencyIndex, typeIndex, incomingDependencyIndex);
    }

    public static List<DependencyWithOccurrenceLocation> getDependenciesWithOccurrenceLocation(UniformPath uniformPath, boolean inverse, TypeDependencyIndex typeDependencyIndex, DependencyListIndex pathDependencyIndex, TypeIndex typeIndex, DependencyListIndex incomingDependencyIndex) throws StorageException {
        uniformPath = uniformPath.resolveToCodePath();
        if (inverse) {
            List<DependencyWithOccurrenceLocation> incomingDependenciesWithOccurrenceInfo = ElementDependencyService.calculateIncomingDependenciesWithOccurrenceInfo(typeDependencyIndex, pathDependencyIndex, uniformPath, typeIndex, incomingDependencyIndex);
            return ElementDependencyService.createConciseLocations(incomingDependenciesWithOccurrenceInfo);
        }
        List typeDependency = typeDependencyIndex.getTypeDependencies(uniformPath.toString());
        List<DependencyWithOccurrenceLocation> outgoingDependenciesWithOccurrenceInfo = ElementDependencyService.calculateOutgoingDependenciesWithOccurrenceInfo(pathDependencyIndex, uniformPath, typeIndex, typeDependency);
        return ElementDependencyService.createConciseLocations(outgoingDependenciesWithOccurrenceInfo);
    }

    private static List<DependencyWithOccurrenceLocation> calculateIncomingDependenciesWithOccurrenceInfo(TypeDependencyIndex typeDependencyIndex, DependencyListIndex pathDependencyIndex, UniformPath uniformPath, TypeIndex typeIndex, DependencyListIndex incomingDependencyIndex) throws StorageException {
        List inversePathDependencies = CollectionUtils.emptyIfNull((List)incomingDependencyIndex.getDependingUniformPaths(uniformPath));
        ArrayList<DependencyWithOccurrenceLocation> incomingDependenciesWithOccurrenceInfo = new ArrayList<DependencyWithOccurrenceLocation>();
        for (String inversePathDependency : inversePathDependencies) {
            HashSet outgoingDependency = new HashSet(CollectionUtils.emptyIfNull((List)pathDependencyIndex.getDependencies(inversePathDependency)));
            if (!outgoingDependency.contains(uniformPath.toString())) continue;
            List typesForFiles = typeIndex.getTypeNamesForFiles(Collections.singletonList(uniformPath.toString()));
            List typeDependency = typeDependencyIndex.getTypeDependencies(inversePathDependency);
            for (String typeForFile : (List)typesForFiles.get(0)) {
                incomingDependenciesWithOccurrenceInfo.addAll(ElementDependencyService.generateDependenciesWithOccurrenceInfo(typeDependency, inversePathDependency, typeForFile));
            }
        }
        return incomingDependenciesWithOccurrenceInfo;
    }

    private static List<DependencyWithOccurrenceLocation> calculateOutgoingDependenciesWithOccurrenceInfo(DependencyListIndex pathDependencyIndex, UniformPath uniformPath, TypeIndex typeIndex, List<TypeDependencies> typeDependenciesInUniformPath) throws StorageException {
        List outgoingDependencyUniformPaths = CollectionUtils.emptyIfNull((List)pathDependencyIndex.getDependingUniformPaths(uniformPath));
        List typesForDependencyFiles = typeIndex.getTypeNamesForFiles(outgoingDependencyUniformPaths);
        ArrayList<DependencyWithOccurrenceLocation> outgoingDependenciesWithOccurrenceInfo = new ArrayList<DependencyWithOccurrenceLocation>();
        for (int i = 0; i < outgoingDependencyUniformPaths.size(); ++i) {
            String dependencyUniformPath = (String)outgoingDependencyUniformPaths.get(i);
            List typesForDependencyFile = (List)typesForDependencyFiles.get(i);
            if (typesForDependencyFile == null || typesForDependencyFile.isEmpty()) {
                outgoingDependenciesWithOccurrenceInfo.addAll(ElementDependencyService.generateDependencyObjectsForThirdParty(typeDependenciesInUniformPath, dependencyUniformPath));
                continue;
            }
            for (String typeForDependencyFile : typesForDependencyFile) {
                outgoingDependenciesWithOccurrenceInfo.addAll(ElementDependencyService.generateDependenciesWithOccurrenceInfo(typeDependenciesInUniformPath, dependencyUniformPath, typeForDependencyFile));
            }
        }
        return outgoingDependenciesWithOccurrenceInfo;
    }

    private static List<DependencyWithOccurrenceLocation> generateDependencyObjectsForThirdParty(List<TypeDependencies> typeDependenciesInUniformPath, String dependencyUniformPath) {
        ArrayList<DependencyWithOccurrenceLocation> dependencyTransportObjects = new ArrayList<DependencyWithOccurrenceLocation>();
        HashSet seenLocations = new HashSet();
        IdentityHashSet locations = new IdentityHashSet((Collection)CollectionUtils.unionSetAll((Collection)CollectionUtils.filterNullEntries((Collection)CollectionUtils.map(typeDependenciesInUniformPath, dep -> (List)dep.getDependencyLocations().get(dependencyUniformPath)))));
        dependencyTransportObjects.addAll(CollectionUtils.filterAndMap((Collection)locations, location -> location instanceof TextRegionLocation && seenLocations.add(location.toLocationString()), location -> new DependencyWithOccurrenceLocation(dependencyUniformPath, location.getUniformPath(), ((TextRegionLocation)location).getRawStartLine())));
        if (locations.isEmpty()) {
            dependencyTransportObjects.add(new DependencyWithOccurrenceLocation(dependencyUniformPath, "", -1));
        }
        return dependencyTransportObjects;
    }

    private static List<DependencyWithOccurrenceLocation> generateDependenciesWithOccurrenceInfo(List<TypeDependencies> typeDependenciesInUniformPath, String dependencyUniformPath, String typeForDependencyFile) {
        ArrayList<DependencyWithOccurrenceLocation> dependencyTransportObjects = new ArrayList<DependencyWithOccurrenceLocation>();
        for (TypeDependencies dependencies : typeDependenciesInUniformPath) {
            List textRegionLocations = dependencies.getDependencyLocations().getOrDefault(typeForDependencyFile, Collections.emptyList());
            for (ElementLocation elementLocation : textRegionLocations) {
                if (!(elementLocation instanceof TextRegionLocation)) continue;
                dependencyTransportObjects.add(new DependencyWithOccurrenceLocation(dependencyUniformPath, elementLocation.getUniformPath(), ((TextRegionLocation)elementLocation).getRawStartLine()));
            }
        }
        return dependencyTransportObjects;
    }

    private static List<DependencyWithOccurrenceLocation> createConciseLocations(List<DependencyWithOccurrenceLocation> dependenciesWithOccurrenceInfo) {
        SetMap dependencyLocationMap = new SetMap();
        for (DependencyWithOccurrenceLocation dependencyWithOccurrenceLocation : dependenciesWithOccurrenceInfo) {
            DependencyLocationKey locationKey = new DependencyLocationKey(dependencyWithOccurrenceLocation.dependencyUniformPath, dependencyWithOccurrenceLocation.dependencyLocationUniformPath);
            dependencyLocationMap.add((Object)locationKey, (Object)dependencyWithOccurrenceLocation.dependencyLocation);
        }
        ArrayList<DependencyWithOccurrenceLocation> finalDependencyWithOccurrenceLocation = new ArrayList<DependencyWithOccurrenceLocation>();
        UnmodifiableSet keys = dependencyLocationMap.getKeys();
        for (DependencyLocationKey key : keys) {
            ArrayList<Integer> values = new ArrayList<Integer>(dependencyLocationMap.getCollection((Object)key));
            Collections.sort(values);
            finalDependencyWithOccurrenceLocation.add(new DependencyWithOccurrenceLocation(key.dependencyUniformPath, key.dependencyLocationUniformPath, values));
        }
        return finalDependencyWithOccurrenceLocation;
    }

    public static class DependencyWithOccurrenceLocation {
        private static final String DEPENDENCY_UNIFORM_PATH_PROPERTY = "dependencyUniformPath";
        private static final String DEPENDENCY_LOCATION_UNIFORM_PATH_PROPERTY = "dependencyLocationUniformPath";
        private static final String DEPENDENCY_LOCATION_PROPERTY = "dependencyLocation";
        private static final String DEPENDENCY_LOCATIONS_PROPERTY = "dependencyLocations";
        @JsonProperty(value="dependencyUniformPath")
        private final String dependencyUniformPath;
        @JsonProperty(value="dependencyLocationUniformPath")
        private final String dependencyLocationUniformPath;
        @JsonProperty(value="dependencyLocation")
        private final int dependencyLocation;
        @JsonProperty(value="dependencyLocations")
        private final List<Integer> dependencyLocations;

        public DependencyWithOccurrenceLocation(String dependencyUniformPath, String dependencyLocationUniformPath, int dependencyLocation) {
            this.dependencyUniformPath = dependencyUniformPath;
            this.dependencyLocationUniformPath = dependencyLocationUniformPath;
            this.dependencyLocation = dependencyLocation;
            this.dependencyLocations = new ArrayList<Integer>();
        }

        public DependencyWithOccurrenceLocation(String dependencyUniformPath, String dependencyLocationUniformPath, List<Integer> dependencyLocations) {
            this.dependencyUniformPath = dependencyUniformPath;
            this.dependencyLocationUniformPath = dependencyLocationUniformPath;
            this.dependencyLocation = -1;
            this.dependencyLocations = dependencyLocations;
        }

        @JsonCreator
        private DependencyWithOccurrenceLocation(@JsonProperty(value="dependencyUniformPath") String dependencyUniformPath, @JsonProperty(value="dependencyLocationUniformPath") String dependencyLocationUniformPath, @JsonProperty(value="dependencyLocation") int dependencyLocation, @JsonProperty(value="dependencyLocations") List<Integer> dependencyLocations) {
            this.dependencyUniformPath = dependencyUniformPath;
            this.dependencyLocationUniformPath = dependencyLocationUniformPath;
            this.dependencyLocation = dependencyLocation;
            this.dependencyLocations = dependencyLocations;
        }

        public String toString() {
            return this.dependencyUniformPath + ", " + this.dependencyLocationUniformPath + ", " + String.valueOf(this.dependencyLocations);
        }

        public String getDependencyUniformPath() {
            return this.dependencyUniformPath;
        }

        public List<Integer> getDependencyLocations() {
            return this.dependencyLocations;
        }
    }

    private static class DependencyLocationKey {
        private final String dependencyUniformPath;
        private final String dependencyLocationUniformPath;

        public DependencyLocationKey(String dependencyUniformPath, String dependencyLocationUniformPath) {
            this.dependencyUniformPath = dependencyUniformPath;
            this.dependencyLocationUniformPath = dependencyLocationUniformPath;
        }

        public int hashCode() {
            return Objects.hash(this.dependencyUniformPath, this.dependencyLocationUniformPath);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DependencyLocationKey)) {
                return false;
            }
            DependencyLocationKey data = (DependencyLocationKey)obj;
            return Objects.equals(this.dependencyLocationUniformPath, data.dependencyLocationUniformPath) && Objects.equals(this.dependencyUniformPath, data.dependencyUniformPath);
        }
    }
}

