/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKeyDTO;
import com.teamscale.core.authenticate.teamscale.accesskeys.AccessKeyHandler;
import com.teamscale.core.authenticate.teamscale.accesskeys.EncryptedAccessKeyIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.service.authenticate.IAccessKeyServiceApi;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.Path;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/users/{user}/access-key")
public class AccessKeyService
extends ApiBase
implements IAccessKeyServiceApi {
    @Override
    public String createNewRandomAccessKey(String username) throws StorageException {
        return AccessKeyHandler.createAndStoreEncryptedAccessKey((String)username, (EncryptedAccessKeyIndex)this.getIndex());
    }

    @Override
    public List<AccessKeyDTO> getAccessKeysMetadata(String username) throws StorageException {
        List accessKeys = this.getIndex().getAccessKeys(username);
        return accessKeys.stream().map(AccessKeyDTO::new).toList();
    }

    @Override
    public void removeAccessKeys(String username, Set<String> keysToBeRemoved) throws StorageException {
        AuditLogs.accessKeysRemoved((String)username, (int)keysToBeRemoved.size());
        this.getIndex().removeAccessKeys(username, keysToBeRemoved);
    }

    private EncryptedAccessKeyIndex getIndex() throws StorageException {
        return this.openGlobalIndex(EncryptedAccessKeyIndex.class);
    }
}

