/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.base;

import com.teamscale.service.base.TimeRange;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TimeRangeResourceServiceQueryOptions {
    public static final String FIRST_TIMESTAMP_PARAMETER_NAME = "t1";
    public static final String SECOND_TIMESTAMP_PARAMETER_NAME = "t2";
    public static final String FIRST_TIMESTAMP_PARAMETER_DESCRIPTION = "Range start timestamp";
    public static final String SECOND_TIMESTAMP_PARAMETER_DESCRIPTION = "Range end timestamp";
    public static final String LENGTH_PARAMETER_NAME = "max-milliseconds";
    @Parameter(description="Range start timestamp")
    @QueryParam(value="t1")
    private UnresolvedCommitDescriptor start;
    @Parameter(description="Range end timestamp")
    @QueryParam(value="t2")
    private UnresolvedCommitDescriptor end;
    @Parameter(description="Range duration in milliseconds")
    @QueryParam(value="max-milliseconds")
    @DefaultValue(value="-1")
    private long length;
    @Parameter(description="Uniform path to retrieve data for", allowEmptyValue=true)
    @DefaultValue(value="")
    @QueryParam(value="uniform-path")
    private UniformPath uniformPath;

    public TimeRangeResourceServiceQueryOptions() {
    }

    public TimeRangeResourceServiceQueryOptions(UnresolvedCommitDescriptor start, UnresolvedCommitDescriptor end, long length, UniformPath uniformPath) {
        this.start = start;
        this.end = end;
        this.length = length;
        this.uniformPath = uniformPath;
    }

    public UnresolvedCommitDescriptor getStart() {
        return this.start;
    }

    public UnresolvedCommitDescriptor getEnd() {
        return this.end;
    }

    public long getLength() {
        return this.length;
    }

    public UniformPath getUniformPath() {
        return this.uniformPath;
    }

    public TimeRange resolve(IFactory<ProjectStorageSystem, StorageException> projectStorageSystemFactory) throws StorageException {
        TimeRange range = TimeRange.resolveTimeRange(this.getStart(), this.getEnd(), this.getLength(), projectStorageSystemFactory);
        if (range.end().getTimestamp() < range.start().getTimestamp()) {
            throw new BadRequestException("t2 (" + this.getEnd().getTimestamp() + ") must be greater or equal than t1(" + this.getStart().getTimestamp() + ").");
        }
        return range;
    }
}

