/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogFileHistoryEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.service.commits.ECommitAttribute;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.commits.RepositoryLogFilterBase;
import com.teamscale.service.testgap.method_history.MethodHistoryEntry;
import com.teamscale.service.testgap.method_history.UserResolvedMethodHistoryEntry;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class ResourceAndMethodHistoryFilter
extends RepositoryLogFilterBase {
    @Hidden
    private final CommitAlertIndex commitAlertIndex;

    private ResourceAndMethodHistoryFilter(RepositoryLogFilter repositoryLogFilterParam, CommitAlertIndex commitAlertIndex, String filteringBranchName) {
        super(repositoryLogFilterParam.commitTypes, repositoryLogFilterParam.commitAttribute, repositoryLogFilterParam.excludeOtherBranches, filteringBranchName);
        this.commitAlertIndex = commitAlertIndex;
    }

    public static ResourceAndMethodHistoryFilter createFromFilterParam(RepositoryLogFilter repositoryLogFilterParam, CommitAlertIndex commitAlertIndex, String filteringBranchName) {
        if (CollectionUtils.isNullOrEmpty((Collection)repositoryLogFilterParam.commitTypes) && !repositoryLogFilterParam.excludeOtherBranches) {
            return null;
        }
        return new ResourceAndMethodHistoryFilter(repositoryLogFilterParam, commitAlertIndex, filteringBranchName);
    }

    public SortedSet<UserResolvedMethodHistoryEntry> filterMethodHistoryEntries(SortedSet<UserResolvedMethodHistoryEntry> entries, RepositoryLogFileIndex repositoryLogFileIndex) throws StorageException {
        this.commitTypes.add(ECommitType.CODE_COMMIT);
        return new TreeSet<UserResolvedMethodHistoryEntry>(this.filter(entries, IFilterDescriber.of(MethodHistoryEntry::getCommit, u -> u.uniformPath), repositoryLogFileIndex));
    }

    public List<RepositoryLogFileHistoryEntry> filterLogFileHistoryEntries(List<RepositoryLogFileHistoryEntry> entries, RepositoryLogFileIndex repositoryLogFileIndex, String branchName) throws StorageException {
        if (!this.canHaveAnyEffect(entries, branchName)) {
            return entries;
        }
        return this.filter(entries, IFilterDescriber.of(CommitAssociatedObjectBase::getCommit, RepositoryLogFileHistoryEntry::getUniformPath), repositoryLogFileIndex);
    }

    private <T> List<T> filter(Collection<T> elements, IFilterDescriber<? super T> describer, RepositoryLogFileIndex repositoryLogFileIndex) throws StorageException {
        if (this.excludeOtherBranches) {
            elements = elements.stream().filter(entry -> describer.getCommit(entry).isOnBranch(this.filteringBranchName)).toList();
        }
        if (this.commitAttribute != null && this.commitAttribute == ECommitAttribute.HAS_ALERTS) {
            elements = (Collection)IStreamWithException.wrap(elements.stream()).withException(StorageException.class).filter(element -> {
                CommitAlerts alerts = (CommitAlerts)this.commitAlertIndex.getEntry(describer.getCommit(element));
                return alerts != null && alerts.getAlertCount() > 0;
            }).collect(Collectors.toList());
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element2 : elements) {
            Set<Object> logFileCommitTypes = repositoryLogFileIndex.getEntries(describer.getCommit(element2), describer.getUniformPath(element2)).keySet();
            if (logFileCommitTypes.isEmpty()) {
                logFileCommitTypes = Set.of(ECommitType.EXTERNAL_ANALYSIS);
            }
            if (logFileCommitTypes.stream().noneMatch(this.commitTypes::contains)) continue;
            result.add(element2);
        }
        return result;
    }

    private boolean canHaveAnyEffect(List<RepositoryLogFileHistoryEntry> entries, String originalBranchName) {
        return !this.allowsAnyCommitAttribute() || !this.allowsAnyCommitType() || this.excludeOtherBranches || this.hasActiveBranchFilter(entries, originalBranchName);
    }

    private boolean hasActiveBranchFilter(List<RepositoryLogFileHistoryEntry> entries, String originalBranchName) {
        return this.filteringBranchName != null && !entries.stream().allMatch(entry -> entry.getCommit().isOnBranch(originalBranchName));
    }

    private boolean allowsAnyCommitType() {
        return CollectionUtils.isNullOrEmpty((Collection)this.commitTypes) || this.commitTypes.stream().distinct().toList().size() == ECommitType.values().length;
    }

    private boolean allowsAnyCommitAttribute() {
        return this.commitAttribute == null || this.commitAttribute == ECommitAttribute.IS_ANY_COMMIT;
    }

    private static interface IFilterDescriber<T> {
        public CommitDescriptor getCommit(T var1);

        public UniformPath getUniformPath(T var1);

        public static <T> IFilterDescriber<T> of(final Function<? super T, ? extends CommitDescriptor> commit, final Function<? super T, ? extends UniformPath> uniformPath) {
            return new IFilterDescriber<T>(){

                @Override
                public CommitDescriptor getCommit(T element) {
                    return (CommitDescriptor)commit.apply(element);
                }

                @Override
                public UniformPath getUniformPath(T element) {
                    return (UniformPath)uniformPath.apply(element);
                }
            };
        }
    }
}

