/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.properties;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public interface IExternalPropertiesServiceApi {
    @GET
    @Path(value="findings/{findingId}/due-date")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get due date", description="Gets the due date for a finding.", tags={"Findings"})
    @ApiResponse(responseCode="204", description="No due date is set for this finding")
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public @Nullable Long getFindingDueDate(@PathParam(value="findingId") @Parameter(description="The ID of the finding") String var1) throws StorageException;

    @PUT
    @Path(value="findings/{findingId}/due-date")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set due date", description="Sets the due date for a finding as a Unix timestamp in milliseconds.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setFindingDueDate(@PathParam(value="findingId") @Parameter(description="The ID of the finding") String var1, @Parameter(description="Due date as Unix timestamp in milliseconds") long var2) throws StorageException;

    @POST
    @Path(value="findings/due-dates")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set due dates for multiple findings", description="Sets due dates for multiple findings in a single request.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setFindingDueDates(@Schema(description="Map of finding ID to due date (Unix timestamp in milliseconds)", example="{\"finding1\": 1640995200000, \"finding2\": 1640995300000}") Map<String, Long> var1) throws StorageException;

    @DELETE
    @Path(value="findings/{findingId}/due-date")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Delete due date", description="Deletes the due date for a finding.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void deleteFindingDueDate(@PathParam(value="findingId") @Parameter(description="The ID of the finding") String var1) throws StorageException;

    @GET
    @Path(value="findings/{findingId}/properties")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get generic external properties", description="Gets generic external properties for a finding.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public Map<String, String> getFindingGenericProperties(@PathParam(value="findingId") @Parameter(description="The ID of the finding") String var1) throws StorageException;

    @PUT
    @Path(value="findings/{findingId}/properties")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set generic external properties", description="Sets generic external properties for a finding. This replaces all existing properties.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setFindingGenericProperties(@PathParam(value="findingId") @Parameter(description="The ID of the finding") String var1, @Parameter(description="Map of key-value properties to set") Map<String, String> var2) throws StorageException;

    @POST
    @Path(value="findings/properties")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set generic properties for multiple findings", description="Sets generic properties for multiple findings in a single request.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setMultipleFindingGenericProperties(@Schema(description="Map of finding ID to properties (key-value pairs)", example="{\"finding1\": {\"priority\": \"high\", \"owner\": \"john\"}, \"finding2\": {\"priority\": \"low\"}}") Map<String, Map<String, String>> var1) throws StorageException;

    @DELETE
    @Path(value="findings/{findingId}/properties")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Delete generic external properties", description="Deletes generic external properties for a finding.", tags={"Findings"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void deleteFindingGenericProperties(@PathParam(value="findingId") @Parameter(description="The ID of the finding") String var1) throws StorageException;

    @GET
    @Path(value="violations/{violationId}/due-date")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get due date", description="Gets the due date for a violation.", tags={"Software Composition"})
    @ApiResponse(responseCode="204", description="No due date is set for this violation")
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public @Nullable Long getViolationDueDate(@PathParam(value="violationId") @Parameter(description="The ID of the violation") String var1) throws StorageException;

    @PUT
    @Path(value="violations/{violationId}/due-date")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set due date", description="Sets the due date for a violation as a Unix timestamp in milliseconds.", tags={"Software Composition"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setViolationDueDate(@PathParam(value="violationId") @Parameter(description="The ID of the violation") String var1, @Parameter(description="Due date as Unix timestamp in milliseconds") long var2) throws StorageException;

    @POST
    @Path(value="violations/due-dates")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set due dates for multiple violations", description="Sets due dates for multiple violations in a single request.", tags={"Software Composition"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setViolationDueDates(@Schema(description="Map of violation ID to due date (Unix timestamp in milliseconds)", example="{\"violation1\": 1640995200000, \"violation2\": 1640995300000}") Map<String, Long> var1) throws StorageException;

    @DELETE
    @Path(value="violations/{violationId}/due-date")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Delete due date", description="Deletes the due date for a violation.", tags={"Software Composition"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void deleteViolationDueDate(@PathParam(value="violationId") @Parameter(description="The ID of the violation") String var1) throws StorageException;

    @GET
    @Path(value="violations/{violationId}/properties")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get generic external properties", description="Gets generic external properties for a violation.", tags={"Software Composition"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public Map<String, String> getViolationGenericProperties(@PathParam(value="violationId") @Parameter(description="The ID of the violation") String var1) throws StorageException;

    @PUT
    @Path(value="violations/{violationId}/properties")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set generic external properties", description="Sets generic external properties for a violation. Replaces all existing properties.", tags={"Software Composition"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setViolationGenericProperties(@PathParam(value="violationId") @Parameter(description="The ID of the violation") String var1, @Schema(description="Map of property key to value", example="{\"key1\": \"value1\", \"key2\": \"value2\"}") Map<String, String> var2) throws StorageException;

    @POST
    @Path(value="violations/properties")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Set properties for multiple violations", description="Sets generic external properties for multiple violations in a single request.", tags={"Software Composition"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void setViolationGenericProperties(@Schema(description="Map of violation ID to property map", example="{\"violation1\": {\"key1\": \"value1\"}, \"violation2\": {\"key2\": \"value2\"}}") Map<String, Map<String, String>> var1) throws StorageException;

    @DELETE
    @Path(value="violations/{violationId}/properties")
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Operation(summary="Delete all generic external properties", description="Deletes all generic external properties for a violation.", tags={"Software Composition"})
    @PublicApi(since=ETeamscaleVersion.VERSION_2025_9_0)
    public void deleteViolationGenericProperties(@PathParam(value="violationId") @Parameter(description="The ID of the violation") String var1) throws StorageException;
}

