/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.index.baseline.BaselineIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/baselines")
public class GlobalBaselineService
extends ApiBase {
    @GET
    @Operation(summary="Get all baselines", description="Returns a list of all configured baselines for the given projects or for all visible projects if no project ID is given.", tags={"Baselines"})
    @RequiresNoPermission(description="No permissions needed, as the service checks if all listed projects are visible to the user.")
    public Map<String, List<BaselineInfo>> getBaselines(@QueryParam(value="project") List<String> projectIds) throws StorageException {
        return this.getAllBaselinesByProjects(projectIds);
    }

    private Map<String, List<BaselineInfo>> getAllBaselinesByProjects(List<String> projectIds) throws StorageException {
        List projects = PermissionUtils.getVisibleProjectIds((GlobalStorageSystem)this.getGlobalStorageSystem(), (ServicePermissions)this.getPermissions(), (List)PublicProjectId.of(projectIds));
        if (projects.isEmpty()) {
            return new HashMap<String, List<BaselineInfo>>();
        }
        HashMap<String, List<BaselineInfo>> baselinesByProject = new HashMap<String, List<BaselineInfo>>();
        for (IProjectId project : projects) {
            BaselineIndex baselineIndex = (BaselineIndex)this.serviceInfo.getProjectStorageSystem(project).openProjectIndex(BaselineIndex.class, null);
            baselinesByProject.put(project.toString(), baselineIndex.getAllBaselines());
        }
        return baselinesByProject;
    }
}

