/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.metrics;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.links.TeamscaleLinkProvider;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.merge_request.MergeRequestMetricEvaluator;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.merge_request.metrics.IMergeRequestMetricEvaluationResult;
import com.teamscale.index.repository.git.common.VotingConnectorUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.merge_request.metrics.MergeRequestMetricBadgesConfigurations;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/merge-requests/{idWithRepository}/metrics")
public class MergeRequestMetricsService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get metric badges configuration for the given merge request.", description="Get metric badges configuration for the given merge request.", tags={"Merge Requests", "Metrics"}, responses={@ApiResponse(responseCode="404", description="Project with the given id was not found."), @ApiResponse(responseCode="404", description="Connector for the given merge request identifier was not found."), @ApiResponse(responseCode="500", description="Failed to read project configuration."), @ApiResponse(responseCode="500", description="Failed to parse metric badge configuration.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="badge-configurations")
    public MergeRequestMetricBadgesConfigurations getMetricBadgesConfigurationForMergeRequest(@PathParam(value="project") PublicProjectId project, @PathParam(value="idWithRepository") MergeRequestIdentifier mergeRequestIdentifier) throws StorageException, ProjectConfigurationException {
        MetricBadgesConfiguration singleMetricBadgesConfiguration = this.getMetricBadgesConfigurationFromConnectorOption(project, mergeRequestIdentifier, "Badges for Metrics");
        MetricBadgesConfiguration metricGroupBadgesConfiguration = this.getMetricBadgesConfigurationFromConnectorOption(project, mergeRequestIdentifier, "Badges for Metric Groups");
        return new MergeRequestMetricBadgesConfigurations(singleMetricBadgesConfiguration.getConfiguredBadges(), metricGroupBadgesConfiguration.getConfiguredBadges());
    }

    private MetricBadgesConfiguration getMetricBadgesConfigurationFromConnectorOption(PublicProjectId project, MergeRequestIdentifier mergeRequestIdentifier, String metricBadgesOptionName) throws StorageException, ProjectConfigurationException {
        ConnectorConfiguration connector = this.getConnector((IProjectId)project, mergeRequestIdentifier);
        try {
            MetricBadgesConfiguration metricBadgesConfiguration = VotingConnectorUtils.getMetricBadgesConfiguration((ConnectorConfiguration)connector, (String)metricBadgesOptionName);
            if (!metricBadgesConfiguration.isEnabled()) {
                LOGGER.atDebug().log("Returning no badge configurations for connector '{}' in project '{}', because the option '{}' is not set.", (Object)connector.getIdentifier(), (Object)project, (Object)metricBadgesOptionName);
            }
            return metricBadgesConfiguration;
        }
        catch (JsonSerializationException e) {
            LOGGER.atError().withThrowable((Throwable)e).log("Failed to parse metric badges configuration for connector '{}' in project '{}'. Raw stored configuration for option '{}':\n{}", (Object)connector.getIdentifier(), (Object)project, (Object)metricBadgesOptionName, (Object)connector.getOptionValue(metricBadgesOptionName));
            throw new ProjectConfigurationException("Error parsing metric badges configuration.", (Throwable)e);
        }
    }

    @POST
    @Operation(summary="Creates a markdown link which renders the metric group badge.", description="Creates a markdown link which renders the metric group badge.", tags={"Merge Requests", "Metrics"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="markdown-group-badge")
    public String createMetricGroupBadgeMarkdown(@PathParam(value="project") PublicProjectId project, @PathParam(value="idWithRepository") MergeRequestIdentifier mergeRequestIdentifier, @RequestBody MetricGroupBadgeEvaluationParameters parameters) throws StorageException {
        return MergeRequestMetricsService.createMarkdownBadge((IMergeRequestMetricEvaluationResult)new MergeRequestMetricEvaluator(this.getGlobalStorageSystem(), (ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)project), parameters.sourceBranch(), parameters.baseCommit(), this.getParallelTaskExecutor()).evaluateMetricGroup(parameters.thresholdConfigurationName(), parameters.metricGroupName(), parameters.metricNames()));
    }

    private static String createMarkdownBadge(IMergeRequestMetricEvaluationResult evaluationResult) {
        String badgeLink = evaluationResult.getBadgeLink(new TeamscaleLinkProvider("/"), MergeRequestMetricsService.omitIncompleteBuildWarningText());
        String textDescription = evaluationResult.getTextDescription();
        String altText = StringUtils.escapeChars((String)textDescription, Map.of("[", "\\[", "]", "\\]"));
        return "[![%s](%s)](%s \"%s\")".formatted(altText, badgeLink, badgeLink, textDescription);
    }

    private ConnectorConfiguration getConnector(IProjectId project, MergeRequestIdentifier mergeRequestIdentifier) throws StorageException {
        Optional connectorConfiguration = MergeRequestUtils.guessConnectorFromProject((IndexLayer)this.getIndexLayer(), (IProjectId)project, (String)mergeRequestIdentifier.repositoryName());
        if (connectorConfiguration.isEmpty()) {
            throw new NotFoundException("Could not find connector for merge request '%s' in project '%s'.".formatted(mergeRequestIdentifier, project));
        }
        return (ConnectorConfiguration)connectorConfiguration.get();
    }

    private static @Nullable String omitIncompleteBuildWarningText() {
        return null;
    }

    public record MetricGroupBadgeEvaluationParameters(@JsonProperty(value="baseCommit") CommitDescriptor baseCommit, @JsonProperty(value="sourceBranch") String sourceBranch, @JsonProperty(value="thresholdConfigurationName") String thresholdConfigurationName, @JsonProperty(value="metricGroupName") String metricGroupName, @JsonProperty(value="metricNames") List<String> metricNames) {
    }
}

