/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.history;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceBase;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@ReadCacheEnabled
@Path(value="api/projects/{project}/metrics/delta")
public class MetricDeltaService
extends TimeRangeResourceServiceBase {
    @GET
    @Operation(summary="Get metric delta", description="Provides the metric delta (i.e., the changes in metric values) for a given uniform path and time range.", tags={"Metrics", "Delta"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<MetricDeltaValue> getMetricDelta(@BeanParam TimeRangeResourceServiceQueryOptions parameters) throws StorageException {
        TimeRange range = this.createTimeRange(parameters);
        return this.calculateMetricDelta(parameters.getUniformPath(), range.start(), range.end());
    }

    private List<MetricDeltaValue> calculateMetricDelta(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        MetricDirectorySchema schema = this.getMetricDirectorySchema(uniformPath, end);
        MetricDirectoryEntry startMetrics = this.getMetricsAtCommit(uniformPath, start, schema);
        MetricDirectoryEntry endMetrics = this.getMetricsAtCommit(uniformPath, end, schema);
        return MetricDeltaService.determineDelta(schema, endMetrics, startMetrics);
    }

    private MetricDirectoryEntry getMetricsAtCommit(UniformPath uniformPath, CommitDescriptor commit, MetricDirectorySchema schema) throws StorageException {
        HistoryAccessOption historyAccess;
        IMetricRetrievalStrategy strategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        MetricDirectoryEntry metrics = strategy.getMetricDirectoryEntry(uniformPath, historyAccess = HistoryAccessOption.readCommit((CommitDescriptor)commit));
        if (metrics == null) {
            metrics = new MetricDirectoryEntry(uniformPath.toString(), schema);
        }
        return metrics;
    }

    private static List<MetricDeltaValue> determineDelta(MetricDirectorySchema schema, MetricDirectoryEntry endMetrics, MetricDirectoryEntry startMetrics) {
        ArrayList<MetricDeltaValue> result = new ArrayList<MetricDeltaValue>();
        Object[] startValues = startMetrics.getValues();
        Object[] endValues = endMetrics.getValues();
        block5: for (int i = 0; i < startValues.length; ++i) {
            Object value1 = startValues[i];
            Object value2 = endValues[i];
            switch (schema.getEntry(i).getValueType()) {
                case NUMERIC: {
                    MetricDeltaService.processNumericDelta(value1, value2, result);
                    continue block5;
                }
                case ASSESSMENT: {
                    MetricDeltaService.processAssessmentDelta(value1, value2, result);
                    continue block5;
                }
                case DATE_ONLY: 
                case TIMESTAMP: {
                    result.add(new MetricDeltaValue(Math.max(MetricDeltaService.getValueNullSafe((Long)value2, 0L), MetricDeltaService.getValueNullSafe((Long)value1, 0L)), MetricDeltaService.getValueNullSafe((Long)value2, 0L)));
                    continue block5;
                }
                default: {
                    result.add(new MetricDeltaValue(null));
                }
            }
        }
        return result;
    }

    private static void processNumericDelta(Object value1, Object value2, List<MetricDeltaValue> result) {
        Number number1 = (Number)value1;
        Number number2 = (Number)value2;
        Double diff = ((Number)MetricDeltaService.getValueNullSafe(number2, 0.0)).doubleValue() - ((Number)MetricDeltaService.getValueNullSafe(number1, 0.0)).doubleValue();
        result.add(new MetricDeltaValue(diff, ((Number)MetricDeltaService.getValueNullSafe(number2, 0.0)).doubleValue()));
    }

    private static void processAssessmentDelta(Object value1, Object value2, List<MetricDeltaValue> result) {
        Assessment assessment1 = MetricDeltaService.getValueNullSafe((Assessment)value1, new Assessment());
        Assessment assessment2 = MetricDeltaService.getValueNullSafe((Assessment)value2, new Assessment());
        AssessmentDelta delta = new AssessmentDelta();
        for (ETrafficLightColor color : ETrafficLightColor.values()) {
            delta.setDelta(color, assessment2.getColorFrequency(color) - assessment1.getColorFrequency(color));
            delta.setCurrentValue(color, assessment2.getColorFrequency(color));
        }
        result.add(new MetricDeltaValue(delta));
    }

    private MetricDirectorySchema getMetricDirectorySchema(UniformPath uniformPath, CommitDescriptor commit) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        return metricRetrievalStrategy.getMetricDirectorySchema(HistoryAccessOption.readTimestampUnbranched((long)commit.getTimestamp()));
    }

    private static <T> T getValueNullSafe(T value, T valueIfNull) {
        if (value != null) {
            return value;
        }
        return valueIfNull;
    }

    public static class MetricDeltaValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String DIFF_PROPERTY = "diff";
        private static final String CURRENT_VALUE_PROPERTY = "currentvalue";
        @JsonProperty(value="diff")
        @Schema(oneOf={AssessmentDelta.class, Number.class})
        private final @Nullable Object diff;
        @JsonProperty(value="currentvalue")
        @Schema(implementation=Number.class)
        private final @Nullable Object currentValue;

        @JsonCreator
        public MetricDeltaValue(@JsonProperty(value="diff") Object diff, @JsonProperty(value="currentvalue") Object currentValue) {
            this.diff = diff;
            this.currentValue = currentValue;
        }

        public MetricDeltaValue(Object diff) {
            this(diff, null);
        }

        public Object getCurrentValue() {
            return this.currentValue;
        }

        public Object getDiff() {
            return this.diff;
        }

        public String toString() {
            return "diff: " + String.valueOf(this.diff);
        }
    }

    public static class AssessmentDelta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="deltas")
        private final int[] deltas = new int[ETrafficLightColor.values().length];
        @JsonProperty(value="currentvalues")
        private final int[] currentValues = new int[ETrafficLightColor.values().length];

        public void setDelta(ETrafficLightColor color, int delta) {
            this.deltas[color.ordinal()] = delta;
        }

        public void setCurrentValue(ETrafficLightColor color, int currentValue) {
            this.currentValues[color.ordinal()] = currentValue;
        }
    }
}

