/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.tools.ABAPLintConfiguration;
import com.teamscale.index.findings.abaplint.ABAPLintConfigurationFile;
import com.teamscale.index.findings.abaplint.ABAPLintConfigurationFileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.project.analysis_profile.AnalysisProfileImportServiceUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/import-abaplint-configuration")
public class ABAPLintConfigurationFileImportService
extends ApiBase {
    @POST
    @Operation(summary="Upload AbapLint configuration files", description="Uploads AbapLint configuration files which are then converted to Teamscale analysis profiles. Returns a textual summary of the import process", tags={"Analysis profiles"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Consumes(value={"multipart/form-data"})
    public List<ABAPLintConfigurationFileImportSummary> importAbapLintConfigurationFile(@Parameter(required=true, array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="configuration-files") List<FormDataBodyPart> configurationFiles, @FormDataParam(value="enable-teamscale-defaults") boolean enableTeamscaleDefaults) throws ProjectConfigurationException, JsonSerializationException, StorageException {
        ABAPLintConfiguration configuration = ABAPLintConfiguration.getInstance();
        configuration.processMappingsAndDescription(CodeScopeAware.DEFAULT_CODE_SCOPE);
        Map groupToQualityIndicator = configuration.getGroupToQualityIndicator(CodeScopeAware.DEFAULT_CODE_SCOPE);
        Map findingDescriptorsByFindingGroup = configuration.getFindingDescriptorsByFindingTypeId(CodeScopeAware.DEFAULT_CODE_SCOPE);
        ListMap findingDescriptorsByAnalysisGroup = configuration.getFindingDescriptorsByAnalysisGroup(CodeScopeAware.DEFAULT_CODE_SCOPE);
        ArrayList<ABAPLintConfigurationFileImportSummary> result = new ArrayList<ABAPLintConfigurationFileImportSummary>();
        for (FormDataBodyPart data : configurationFiles) {
            result.add(this.importConfigurationFile(data, enableTeamscaleDefaults, groupToQualityIndicator, (ListMap<String, FindingDescriptor>)findingDescriptorsByAnalysisGroup, findingDescriptorsByFindingGroup));
        }
        return result;
    }

    private ABAPLintConfigurationFileImportSummary importConfigurationFile(FormDataBodyPart data, boolean enableTeamscaleDefaults, Map<String, String> groupToQualityIndicator, ListMap<String, FindingDescriptor> findingDescriptorsByAnalysisGroup, Map<String, FindingDescriptor> findingDescriptorsByFindingGroup) throws ProjectConfigurationException, JsonSerializationException, StorageException {
        String profileName = data.getFormDataContentDisposition().getFileName();
        profileName = profileName.substring(0, profileName.indexOf(".json"));
        ConfigurationTemplate configurationTemplate = AnalysisProfileImportServiceUtils.getConfigurationTemplate(EAnalysisTool.ABAPLINT, Set.of(ELanguage.ABAP), enableTeamscaleDefaults, groupToQualityIndicator, this.getGlobalStorageSystem());
        AnalysisProfile analysisProfile = new AnalysisProfile(profileName, Set.of(ELanguage.ABAP), Set.of(EAnalysisTool.ABAPLINT));
        AnalysisProfileUtils.createQualityIndicators((AnalysisProfile)analysisProfile, (ConfigurationTemplate)configurationTemplate);
        AnalysisProfileUtils.createGlobalOptions((AnalysisProfile)analysisProfile, (ConfigurationTemplate)configurationTemplate);
        Map<String, AnalysisGroup> analysisGroupsByName = analysisProfile.getQualityIndicators().stream().flatMap(indicator -> indicator.getGroups().stream()).collect(Collectors.toMap(NamedConfigurableObjectBase::getName, Function.identity()));
        ABAPLintConfigurationFileImportSummary summary = new ABAPLintConfigurationFileImportSummary(profileName);
        ABAPLintConfigurationFileImportService.addRulesAndLanguageVersionFromConfigurationFileToAnalysisProfile(data, findingDescriptorsByAnalysisGroup, summary, analysisProfile, analysisGroupsByName);
        if (!enableTeamscaleDefaults) {
            AnalysisProfileImportServiceUtils.disableTeamscaleDefaultChecks(analysisGroupsByName.values(), configurationTemplate, findingDescriptorsByFindingGroup.keySet());
        }
        AnalysisProfileImportServiceUtils.writeProfile(analysisProfile, this.getGlobalStorageSystem(), this.getPermissions());
        return summary;
    }

    private static void addRulesAndLanguageVersionFromConfigurationFileToAnalysisProfile(FormDataBodyPart data, ListMap<String, FindingDescriptor> findingDescriptorsByAnalysisGroup, ABAPLintConfigurationFileImportSummary summary, AnalysisProfile analysisProfile, Map<String, AnalysisGroup> analysisGroupsByName) throws JsonSerializationException {
        ABAPLintConfigurationFile abapLintConfigurationFile = (ABAPLintConfigurationFile)JsonUtils.deserializeFromJson((String)StringUtils.bytesToString((byte[])((byte[])data.getEntityAs(byte[].class))), ABAPLintConfigurationFile.class);
        Map rulesFromAbapLintConfigurationFile = abapLintConfigurationFile.getRules();
        summary.overallChecks = rulesFromAbapLintConfigurationFile.size();
        HashSet<String> usedRuleIds = new HashSet<String>();
        for (String analysisGroup : findingDescriptorsByAnalysisGroup.getKeys()) {
            for (FindingDescriptor findingDescriptor : (List)findingDescriptorsByAnalysisGroup.getCollection((Object)analysisGroup)) {
                String checkId = findingDescriptor.getName();
                if (abapLintConfigurationFile.hasCheck(checkId)) {
                    ABAPLintConfigurationFileImportService.addCheckWithOptions(summary, abapLintConfigurationFile, analysisGroupsByName, usedRuleIds, analysisGroup, findingDescriptor, checkId);
                    continue;
                }
                analysisGroupsByName.get(analysisGroup).setOptionValue(checkId, EFindingEnablement.OFF.toString());
            }
        }
        summary.unsupportedChecks.addAll(CollectionUtils.subtract(rulesFromAbapLintConfigurationFile.keySet(), usedRuleIds));
        if (abapLintConfigurationFile.hasLanguageVersion()) {
            analysisProfile.getOptions().put("abaplint default language", abapLintConfigurationFile.getLanguageVersion());
        }
    }

    private static void addCheckWithOptions(ABAPLintConfigurationFileImportSummary summary, ABAPLintConfigurationFile abapLintConfigurationFile, Map<String, AnalysisGroup> analysisGroupsByName, Set<String> usedRuleIds, String analysisGroup, FindingDescriptor findingDescriptor, String checkId) {
        usedRuleIds.add(checkId);
        ++summary.importedChecks;
        if (findingDescriptor.getDefaultFindingEnablement() == EFindingEnablement.OFF) {
            summary.checksWithDefaultSeverity.add(checkId);
            analysisGroupsByName.get(analysisGroup).setOptionValue(checkId, EFindingEnablement.YELLOW.toString());
        } else {
            analysisGroupsByName.get(analysisGroup).setOptionValue(checkId, findingDescriptor.getDefaultFindingEnablement().toString());
        }
        Map<String, String> knownCheckOptionTypesByName = findingDescriptor.getReferencedOptions().stream().collect(Collectors.toMap(ConfigurationItemBase::getName, ConfigOptionDescriptorBase::getType));
        for (String optionName : abapLintConfigurationFile.getRuleOptions(checkId).keySet()) {
            if (optionName.equals("severity") || optionName.equals("exclude")) continue;
            String prefixedCheckOptionId = ABAPLintConfigurationFileUtils.prefixCheckOptionId((String)checkId, (String)optionName);
            if (knownCheckOptionTypesByName.containsKey(prefixedCheckOptionId)) {
                analysisGroupsByName.get(analysisGroup).setOptionValue(prefixedCheckOptionId, abapLintConfigurationFile.getOptionValueAsString(checkId, optionName, knownCheckOptionTypesByName.get(prefixedCheckOptionId)));
                continue;
            }
            summary.unsupportedOptions.add(prefixedCheckOptionId);
        }
    }

    public static class ABAPLintConfigurationFileImportSummary {
        @JsonProperty(value="profileName")
        private final String profileName;
        @JsonProperty(value="overallChecks")
        private int overallChecks = 0;
        @JsonProperty(value="importedChecks")
        private int importedChecks = 0;
        @JsonProperty(value="unsupportedChecks")
        private final List<String> unsupportedChecks = new ArrayList<String>();
        @JsonProperty(value="unsupportedOptions")
        private final List<String> unsupportedOptions = new ArrayList<String>();
        @JsonProperty(value="checksWithDefaultSeverity")
        private final List<String> checksWithDefaultSeverity = new ArrayList<String>();

        @JsonCreator
        public ABAPLintConfigurationFileImportSummary(@JsonProperty(value="profileName") String profileName) {
            this.profileName = profileName;
        }
    }
}

