/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.reports.slides;

import com.teamscale.index.quality_report.QualityReport;
import com.teamscale.index.quality_report.slides.AssessmentTrendChartSlide;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.FindingDetailSlide;
import com.teamscale.index.quality_report.slides.ImageSlide;
import com.teamscale.index.quality_report.slides.MarkdownSlide;
import com.teamscale.index.quality_report.slides.MetricBarChartSlide;
import com.teamscale.index.quality_report.slides.MetricTreemapSlide;
import com.teamscale.index.quality_report.slides.MetricTrendChartSlide;
import com.teamscale.index.quality_report.slides.SectionTitleSlide;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.quality_report.slides.SystemQualityOverviewSlide;
import com.teamscale.index.quality_report.slides.TaskDetailSlide;
import com.teamscale.index.quality_report.slides.TasksSlide;
import com.teamscale.index.quality_report.slides.TestGapTreemapSlide;
import com.teamscale.index.quality_report.slides.TitleSlide;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.reports.slides.AssessmentTrendChartSlideRenderer;
import com.teamscale.service.reports.slides.FindingsDetailSlideRenderer;
import com.teamscale.service.reports.slides.ISlideRenderer;
import com.teamscale.service.reports.slides.ImageSlideRenderer;
import com.teamscale.service.reports.slides.MarkdownSlideRenderer;
import com.teamscale.service.reports.slides.MetricBarChartSlideRenderer;
import com.teamscale.service.reports.slides.MetricTreemapSlideRenderer;
import com.teamscale.service.reports.slides.MetricTrendChartSlideRenderer;
import com.teamscale.service.reports.slides.SectionTitleSlideRenderer;
import com.teamscale.service.reports.slides.SlideRenderContext;
import com.teamscale.service.reports.slides.SystemQualityOverviewSlideRenderer;
import com.teamscale.service.reports.slides.TaskDetailSlideRenderer;
import com.teamscale.service.reports.slides.TasksSlideRenderer;
import com.teamscale.service.reports.slides.TestGapTreemapSlideRenderer;
import com.teamscale.service.reports.slides.TitleSlideRenderer;

public class SlideRendererFactory {
    public static <T extends SlideParametersBase> ISlideRenderer createRender(ITeamscaleServiceInfo serviceInfo, EReportSlide type, T parameters, QualityReport report) {
        SlideRenderContext<TitleSlide.TitleSlideParameters> slideRenderContext = new SlideRenderContext<TitleSlide.TitleSlideParameters>(serviceInfo, (TitleSlide.TitleSlideParameters)parameters, report.getQualityArtifactProfile(), report.getMetaInfo().getId());
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EReportSlide.TITLE -> new TitleSlideRenderer(slideRenderContext);
            case EReportSlide.SECTION_TITLE -> new SectionTitleSlideRenderer((SlideRenderContext<SectionTitleSlide.SectionTitleSlideParameters>)slideRenderContext);
            case EReportSlide.METRIC_ASSESSMENT -> new MetricBarChartSlideRenderer((SlideRenderContext<MetricBarChartSlide.MetricBarChartSlideParameters>)slideRenderContext);
            case EReportSlide.SYSTEM_QUALITY_OVERVIEW -> new SystemQualityOverviewSlideRenderer((SlideRenderContext<SystemQualityOverviewSlide.SystemQualityOverviewSlideParameters>)slideRenderContext);
            case EReportSlide.FINDING_DETAIL -> new FindingsDetailSlideRenderer((SlideRenderContext<FindingDetailSlide.FindingDetailSlideParameters>)slideRenderContext);
            case EReportSlide.METRIC_TREND -> new MetricTrendChartSlideRenderer((SlideRenderContext<MetricTrendChartSlide.MetricTrendChartSlideParameters>)slideRenderContext);
            case EReportSlide.ASSESSMENT_TREND -> new AssessmentTrendChartSlideRenderer((SlideRenderContext<AssessmentTrendChartSlide.AssessmentTrendChartSlideParameters>)slideRenderContext);
            case EReportSlide.TEST_GAP_TREEMAP -> new TestGapTreemapSlideRenderer((SlideRenderContext<TestGapTreemapSlide.TestGapTreemapSlideParameters>)slideRenderContext);
            case EReportSlide.TASK_DETAIL -> new TaskDetailSlideRenderer((SlideRenderContext<TaskDetailSlide.TaskDetailSlideParameters>)slideRenderContext);
            case EReportSlide.TASKS -> new TasksSlideRenderer((SlideRenderContext<TasksSlide.TasksSlideParameters>)slideRenderContext);
            case EReportSlide.IMAGE -> new ImageSlideRenderer((SlideRenderContext<ImageSlide.ImageSlideParameters>)slideRenderContext);
            case EReportSlide.MARKDOWN -> new MarkdownSlideRenderer((SlideRenderContext<MarkdownSlide.MarkdownSlideParameters>)slideRenderContext);
            case EReportSlide.METRIC_TREEMAP -> new MetricTreemapSlideRenderer((SlideRenderContext<MetricTreemapSlide.MetricTreemapSlideParameters>)slideRenderContext);
        };
    }
}

