/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.runtime.impl.worker.WorkerClusterStatus;
import com.teamscale.service.system.WorkerStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.conqat.lib.commons.collections.CounterSet;

class WorkerGroupStatus {
    @JsonProperty(value="processId")
    private final String processId;
    @JsonProperty(value="workers")
    private final List<WorkerStatus> workers = new ArrayList<WorkerStatus>();
    @JsonProperty(value="utilization")
    private final double utilization;
    @JsonProperty(value="jobQueueSize")
    private final int jobQueueSize;

    WorkerGroupStatus(WorkerClusterStatus clusterStatus) {
        this.processId = clusterStatus.getProcessId();
        this.utilization = clusterStatus.getWorkerLoad() / (double)Math.max(1, clusterStatus.getWorkerCount());
        this.jobQueueSize = clusterStatus.getJobQueueSize();
        HashMap<String, WorkerClusterStatus.WorkerThreadStatus> threadStatusByWorkerId = new HashMap<String, WorkerClusterStatus.WorkerThreadStatus>();
        CounterSet supportersByWorkerId = new CounterSet();
        for (WorkerClusterStatus.WorkerThreadStatus threadStatus : clusterStatus.getThreadStatuses()) {
            threadStatusByWorkerId.put(threadStatus.getWorkerId(), threadStatus);
            if (threadStatus.getSupportedWorker() == null) continue;
            supportersByWorkerId.inc((Object)threadStatus.getSupportedWorker());
        }
        for (WorkerClusterStatus.WorkerThreadStatus threadStatus : clusterStatus.getThreadStatuses()) {
            if (threadStatus.getSupportedWorker() == null) {
                WorkerStatus workerStatus = new WorkerStatus(threadStatus, supportersByWorkerId.getValue((Object)threadStatus.getWorkerId()));
                this.workers.add(workerStatus);
                continue;
            }
            WorkerStatus supportingWorkerStatus = new WorkerStatus(threadStatus, (WorkerClusterStatus.WorkerThreadStatus)threadStatusByWorkerId.get(threadStatus.getSupportedWorker()));
            this.workers.add(supportingWorkerStatus);
        }
    }

    public String getProcessId() {
        return this.processId;
    }

    public List<WorkerStatus> getWorkers() {
        return this.workers;
    }
}

