/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaNoIssueRequest;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.treemap.TestGapTreeMapWrapper;
import com.teamscale.index.testgap.treemap.TgaMethodTreeMapNode;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.treemap.TgaTreeMapService;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;

@Path(value="api/projects/{project}/unlinked-changes/treemap")
public class UnlinkedChangesTgaService
extends CrossAnnotationServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get unlinked commits", description="Retrieves the commits for changes not linked to any issue.", tags={"Test Gap Analysis", "Issues"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public UnlinkedChangesWrapper getNonIssueTgaCommitsAndTreemap(@BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, @BeanParam TgaCoverageSourceQueryParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentQueryOptions) throws StorageException {
        TgaNoIssueRequest noIssueRequest = TgaNoIssueRequest.createRequest((ITgaCoverageSourceParameter)coverageSourceParameters, (TimeIntervalBasedServiceQueryOptions)timeIntervalBasedParameters, (ETgaAssessmentType)assessmentQueryOptions.getAssessmentType(), (IndexLayer)this.serviceInfo.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId());
        List methods = noIssueRequest.fetchAndAssessData().getChangedMethods(false);
        HashSet<Long> lastChangedTimestamps = new HashSet<Long>();
        for (AssessedTgaData.AssessedMethodData method2 : methods) {
            lastChangedTimestamps.add(method2.getLastChangeTimestamp());
        }
        Set<CommitDescriptor> lastChangeCommits = this.getCommitDescriptors(timeIntervalBasedParameters, lastChangedTimestamps);
        Set<CommitDescriptor> importCommits = this.findImportCommits(lastChangeCommits);
        lastChangeCommits.removeAll(importCommits);
        List<AssessedTgaData.AssessedMethodData> finalizedMethods = methods.stream().filter(method -> importCommits.stream().noneMatch(importCommit -> method.getLastChangeTimestamp() == importCommit.getTimestamp())).toList();
        TestGapTreeMapWrapper wrapper = UnlinkedChangesTgaService.getTestGapTreeMapWrapper(noIssueRequest, finalizedMethods);
        return new UnlinkedChangesWrapper(wrapper, lastChangeCommits);
    }

    private @NonNull Set<CommitDescriptor> findImportCommits(Set<CommitDescriptor> finalizedCommits) throws StorageException {
        RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        HashSet<CommitDescriptor> importCommits = new HashSet<CommitDescriptor>();
        for (CommitDescriptor commit : finalizedCommits) {
            RepositoryLogEntryAggregate repositoryLogEntry = (RepositoryLogEntryAggregate)repositoryLogIndex.getEntry(commit);
            CCSMAssert.isTrue((repositoryLogEntry != null ? 1 : 0) != 0, (String)("Commit should have a corresponding log entry: " + String.valueOf(commit)));
            if (!repositoryLogEntry.getAuthor().equals("Teamscale import")) continue;
            importCommits.add(commit);
        }
        return importCommits;
    }

    private static @NonNull TestGapTreeMapWrapper getTestGapTreeMapWrapper(TgaNoIssueRequest noIssueRequest, List<AssessedTgaData.AssessedMethodData> methods) throws StorageException {
        TgaMethodTreeMapNode treemap = TgaTreeMapService.createTreeMap(methods, UniformPath.codeRoot());
        CounterSet stateCounter = TgaAggregationUtils.countStates(methods);
        double ratio = TgaAggregationUtils.calculateRatio((ETgaAssessmentType)noIssueRequest.getTgaAssessmentType(), (CounterSet)stateCounter);
        return new TestGapTreeMapWrapper(treemap, stateCounter, ratio, noIssueRequest.getIndexAccessCommit(), noIssueRequest.getBaselineTimestamp(), noIssueRequest.getPartitions(), (Collection)noIssueRequest.getCrossAnnotationProjects(), noIssueRequest.getTgaAssessmentType());
    }

    private @NonNull Set<CommitDescriptor> getCommitDescriptors(TimeIntervalBasedServiceQueryOptions timeIntervalParameters, Set<Long> lastChangedTimestamps) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = CommitDescriptorIndex.open((IndexLayer)this.getIndexLayer(), (IProjectId)this.serviceInfo.getInternalId());
        CommitDescriptor endCommit = timeIntervalParameters.resolveEndCommit(() -> this.getProjectStorageSystem());
        CommitDescriptor baselineCommit = timeIntervalParameters.resolveBaselineCommit(() -> this.getProjectStorageSystem());
        List commits = commitDescriptorIndex.getCommitHistory(endCommit, baselineCommit.getTimestamp());
        HashSet<CommitDescriptor> finalizedCommits = new HashSet<CommitDescriptor>();
        for (ParentedCommitDescriptor commit : commits) {
            if (!lastChangedTimestamps.contains(commit.getTimestamp())) continue;
            finalizedCommits.add((CommitDescriptor)commit);
        }
        return finalizedCommits;
    }

    public static class UnlinkedChangesWrapper {
        @JsonProperty(value="commits")
        private final Set<CommitDescriptor> commits = new HashSet<CommitDescriptor>();
        @JsonProperty(value="treemapData")
        private final @NonNull TestGapTreeMapWrapper treemapData;

        public UnlinkedChangesWrapper(@NonNull TestGapTreeMapWrapper treemapData, Set<CommitDescriptor> commits) {
            this.treemapData = treemapData;
            this.commits.addAll(commits);
        }

        public boolean isEmpty() {
            return this.commits.isEmpty();
        }
    }
}

