/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.util.BodyPartWrapper;
import com.teamscale.service.testgap.upload.VersionBasedExternalUploadServiceQueryOptions;
import com.teamscale.service.upload.base.ExternalUploadServiceUtils;
import jakarta.ws.rs.BadRequestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

public abstract class SourceLocationBasedUploadServiceBase<T, S extends SessionBasedExternalAnalysisServiceQueryOptions>
extends SessionBasedExternalAnalysisServiceBase<S> {
    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionManager sessionManager, List<IExternalUploadRequestPart> bodyParts, S parameters) throws BadRequestException, StorageException {
        HashSet<T> ids = new HashSet<T>();
        for (IExternalUploadRequestPart part : bodyParts) {
            ids.addAll(this.parseReport((BodyPartWrapper)part));
        }
        HistoryAccessOption historyAccessOption = ExternalUploadServiceUtils.getAccessOptionForDefaultBranch(session.getCommit());
        sessionManager.storeNewImportInfosForSession(session, this.doMappingAndCreateImportInfos(historyAccessOption, ids, parameters));
    }

    protected void processVersionBased(S parameters, List<FormDataBodyPart> reports) throws StorageException, IOException {
        List<BodyPartWrapper> bodyParts = SourceLocationBasedUploadServiceBase.readFormDataBodyParts(reports);
        this.logManager.logReports(bodyParts);
        this.process(EHttpMethod.POST, new ArrayList<BodyPartWrapper>(bodyParts), parameters, "auto-create");
    }

    protected VersionBasedExternalUploadServiceQueryOptions createParameters(String version, String message, String partition) throws StorageException {
        this.logManager.logParameter("version", version);
        DotNetVersionIndex versionIndex = this.openProjectIndex(DotNetVersionIndex.class, null);
        CommitDescriptor commitDescriptor = ExternalUploadServiceUtils.getCommitDescriptorFromVersionIndex(versionIndex, version);
        UnresolvedCommitDescriptor unresolvedCommitDescriptor = commitDescriptor.toUnresolvedCommitDescriptor();
        VersionBasedExternalUploadServiceQueryOptions parameters = new VersionBasedExternalUploadServiceQueryOptions();
        parameters.setVersion(version);
        parameters.setUploadMessage(message);
        parameters.setPartition(partition);
        parameters.setCommit(unresolvedCommitDescriptor);
        return parameters;
    }

    public static ExternalAnalysisImportInfoLineCoverage createImportInfo(long targetCommitTimestamp, String uniformPath, List<SourceLocation> locations) {
        LineCoverageInfo coverageInfo = new LineCoverageInfo(-1L, targetCommitTimestamp, true);
        for (SourceLocation location : locations) {
            for (int i = location.getRegion().getStart(); i <= location.getRegion().getEnd(); ++i) {
                coverageInfo.addLineCoverage(i, ELineCoverage.PARTIALLY_COVERED);
            }
        }
        return new ExternalAnalysisImportInfoLineCoverage(uniformPath, coverageInfo);
    }

    protected abstract Set<T> parseReport(BodyPartWrapper var1);

    protected abstract ExternalAnalysisImportInfos doMappingAndCreateImportInfos(HistoryAccessOption var1, Set<T> var2, S var3) throws StorageException;
}

