/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.google.common.collect.ImmutableSet;
import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.testimpact.PrioritizedTestListIndex;
import com.teamscale.index.testimpact.SelectedTest;
import com.teamscale.index.testimpact.TestMinimizationJobOptionsIndex;
import com.teamscale.index.testimpact.TestMinimizationJobRun;
import com.teamscale.index.testimpact.TestMinimizationJobsIndex;
import com.teamscale.index.testimpact.TestMinimizationRequestOptions;
import com.teamscale.index.utils.AsyncServiceJobRun;
import com.teamscale.service.testimpact.AsyncMinimizationProgressCallback;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.TestMinimizationResult;
import com.teamscale.service.testimpact.TestMinimizationService;
import com.teamscale.service.testimpact.TestSelectionStorageUtils;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

public class TestMinimizationTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() throws Exception {
        TestMinimizationResult result;
        InternalProjectId projectId = this.jobDescriptor.getInternalProjectId();
        String jobId = this.jobDescriptor.getParameter();
        TestMinimizationJobsIndex jobsIndex = this.openJobIndex(projectId);
        TestMinimizationJobRun job = jobsIndex.getJobWithId(jobId);
        if (job == null) {
            throw new StorageException(String.format("Job with id '%s' not found!", jobId));
        }
        if (job.getStatus() != AsyncServiceJobRun.EJobStatus.SCHEDULED) {
            if (job.getStatus() != AsyncServiceJobRun.EJobStatus.FAILED) {
                jobsIndex.setJob(job.getId(), job.withJobStatus(AsyncServiceJobRun.EJobStatus.FAILED));
                LOGGER.warn(String.format("Unfinished test minimization job %s set to FAILED.", job.getId()));
            }
            return;
        }
        MinimizationProgressCallback callback = this.setupProgressReporting(jobsIndex, job, projectId);
        try (MinimizationProgressCallback ignored = callback.processStarts("Overall Progress");){
            callback.setProcessMaxSteps(8);
            TestMinimizationRequestOptions options = this.loadJobOptions(projectId, jobId);
            callback.reportProgress();
            List<SelectedTest> selectedTests = this.loadTestList(jobId);
            options.setTests(selectedTests.stream().map(selectedTest -> new PartitionAndPath(selectedTest.partition(), selectedTest.uniformPath())).collect(Collectors.toSet()));
            result = this.runMinimizationJob(projectId, job, options, callback);
            this.storeMinimizationResult(jobId, projectId, result, callback);
            this.appendTests(jobId, projectId, selectedTests);
            callback.reportProgress();
        }
        catch (Exception e) {
            callback.reportFailure(e.getMessage());
            throw e;
        }
        jobsIndex.setJob(jobId, jobsIndex.getJobWithId(jobId).withJobStatus(AsyncServiceJobRun.EJobStatus.DONE).withProgressStack(Collections.emptyList()).withRetainedCoverage(result.getRetainedTestCoverage()));
    }

    private @NonNull TestMinimizationRequestOptions loadJobOptions(InternalProjectId projectId, String jobId) throws StorageException {
        TestMinimizationJobOptionsIndex jobOptionsIndex = this.openJobOptionsIndex(projectId);
        TestMinimizationRequestOptions options = jobOptionsIndex.getJobOptionsFor(jobId);
        if (options == null) {
            throw new StorageException(String.format("No options for job with id '%s' found!", jobId));
        }
        return options;
    }

    private @NonNull MinimizationProgressCallback setupProgressReporting(TestMinimizationJobsIndex jobsIndex, TestMinimizationJobRun job, InternalProjectId projectId) throws StorageException {
        jobsIndex.setJob(job.getId(), job.withJobStatus(AsyncServiceJobRun.EJobStatus.RUNNING).withProgressStack(Collections.emptyList()).withRetainedCoverage(0.0));
        return this.createMinimizationProgressCallback(projectId, job);
    }

    private List<SelectedTest> loadTestList(String jobId) throws StorageException {
        PrioritizedTestListIndex resultsIndex = this.openJobResultsIndex(this.jobDescriptor.getInternalProjectId());
        return resultsIndex.getTestList(jobId);
    }

    private @NonNull TestMinimizationResult runMinimizationJob(InternalProjectId projectId, TestMinimizationJobRun job, TestMinimizationRequestOptions options, MinimizationProgressCallback callback) throws StorageException, InterruptedException {
        CommitResolvingStorageSystem projectStorage = this.indexLayer.openProjectStorageSystem((IProjectId)projectId);
        GlobalStorageSystem globalStorage = this.indexLayer.openGlobalStorageSystem();
        UserIndex userIndex = (UserIndex)this.indexLayer.openGlobalIndex(UserIndex.class);
        User user = userIndex.getUser(job.getUsername());
        return TestMinimizationService.minimizeTestSuite(options, callback, projectId, user, globalStorage, projectStorage, this.indexLayer);
    }

    private MinimizationProgressCallback createMinimizationProgressCallback(InternalProjectId projectId, TestMinimizationJobRun initialJob) throws StorageException {
        TestMinimizationJobsIndex jobIndex = this.openJobIndex(projectId);
        TestMinimizationJobOptionsIndex jobOptionsIndex = this.openJobOptionsIndex(projectId);
        return new AsyncMinimizationProgressCallback(initialJob.getId(), jobIndex, jobOptionsIndex);
    }

    private void storeMinimizationResult(String jobId, InternalProjectId projectId, TestMinimizationResult result, MinimizationProgressCallback callback) throws StorageException, InterruptedException {
        try (MinimizationProgressCallback ignored = callback.processStarts("Storing Results");){
            PrioritizedTestListIndex resultIndex = this.openJobResultsIndex(projectId);
            resultIndex.clearRankingResult(jobId);
            ArrayList<SelectedTest> tests = new ArrayList<SelectedTest>();
            for (PrioritizableTestCluster cluster : result.getTestCluster()) {
                tests.addAll(CollectionUtils.map((Collection)cluster.getTests(), test -> SelectedTest.withoutRanking((String)test.getUniformPathString(), (String)test.getPartition(), (Long)test.getDurationInMs(0L))));
            }
            this.appendTests(jobId, projectId, tests);
        }
    }

    private void appendTests(String jobId, InternalProjectId projectId, List<SelectedTest> tests) throws StorageException {
        TestMinimizationJobsIndex jobIndex = this.openJobIndex(projectId);
        TestMinimizationJobRun job = jobIndex.getJobWithId(jobId);
        if (job == null) {
            throw new StorageException(String.format("Job with id '%s' not found!", jobId));
        }
        TestSelectionStorageUtils.appendTests(job, jobIndex, this.openJobResultsIndex(projectId), tests);
    }

    private TestMinimizationJobsIndex openJobIndex(InternalProjectId projectId) throws StorageException {
        return (TestMinimizationJobsIndex)this.indexLayer.openProjectStorageSystem((IProjectId)projectId).openProjectIndex(TestMinimizationJobsIndex.class, null);
    }

    private TestMinimizationJobOptionsIndex openJobOptionsIndex(InternalProjectId projectId) throws StorageException {
        return (TestMinimizationJobOptionsIndex)this.indexLayer.openProjectStorageSystem((IProjectId)projectId).openProjectIndex(TestMinimizationJobOptionsIndex.class, null);
    }

    private PrioritizedTestListIndex openJobResultsIndex(InternalProjectId projectId) throws StorageException {
        return (PrioritizedTestListIndex)this.indexLayer.openProjectStorageSystem((IProjectId)projectId).openProjectIndex(PrioritizedTestListIndex.class, null);
    }

    public boolean shouldRescheduleOnError() {
        return false;
    }

    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.OUTPUT_ISOLATED;
    }

    public Set<String> getWriteStores() {
        return ImmutableSet.of((Object)TestMinimizationTrigger.getIndexName(TestMinimizationJobOptionsIndex.class), (Object)TestMinimizationTrigger.getIndexName(TestMinimizationJobsIndex.class), (Object)TestMinimizationTrigger.getIndexName(PrioritizedTestListIndex.class));
    }

    private static <I extends IStorageIndex> String getIndexName(Class<I> indexClass) {
        return IStorageIndex.getIndexAnnotation(indexClass).name();
    }
}

