/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/code/{uniformPath}/methods/{startOffset}-{endOffset}/tests")
public class TestwiseCoverageService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get tests executing a method", description="Returns the tests executing a given method.", responses={@ApiResponse(responseCode="204", description="No testwise coverage was uploaded for this project.")}, tags={"Test Coverage"})
    public PartitionedTestSet getTestsExecutingMethod(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @Parameter(description="The character-based offset in file on which the method starts (at the specified time).") @PathParam(value="startOffset") int startOffset, @Parameter(description="The character-based offset in file on which the method ends (at the specified time).") @PathParam(value="endOffset") int endOffset, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        HistoryAccessOption historyAccessOptionPlus100ms = historyAccessOption.cloneWithNewTimestamp(historyAccessOption.getBranchName(), historyAccessOption.getTimestamp() + 100L);
        MethodLocation methodLocation = new MethodLocation(uniformPath, new OffsetBasedRegion(startOffset, endOffset));
        return this.getAllCoveringTestsForMethodGrouped(methodLocation, historyAccessOptionPlus100ms);
    }

    private PartitionedTestSet getAllCoveringTestsForMethodGrouped(MethodLocation method, HistoryAccessOption historyAccessOption) throws StorageException {
        CoverageUnitToMethodsMapIndex testsToMethodsMapIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        if (testsToMethodsMapIndex.getPartitions().isEmpty()) {
            return null;
        }
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        PartitionedTestSet testPathsByPartition = new PartitionedTestSet();
        MethodId methodId = methodIdIndex.getMethodId(method);
        if (methodId == null) {
            return testPathsByPartition;
        }
        return testsToMethodsMapIndex.getTestsCoveringMethod(methodId);
    }
}

