/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testimpact.ImpactedTestsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/impacted-tests/debug/count")
public class TestImpactCountDebugService
extends ApiBase {
    private static final String DESCRIPTION = "Returns the number of impacted tests for the given time-range. The test are grouped into buckets of the given interval size.";
    private static final char CSV_SEPARATOR_CHAR = ';';

    @Operation(summary="Get impacted tests statistics", description="Returns the number of impacted tests for the given time-range. The test are grouped into buckets of the given interval size.", tags={"Test Intelligence"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"text/csv"})
    @GET
    public Response getImpactedTestsStatistics(@BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalOptions, @QueryParam(value="interval") @Parameter(description="The interval in which impacted tests should be retrieved (in milliseconds)", required=true) int interval) throws StorageException {
        CommitDescriptor baseline = this.resolve(timeIntervalOptions.getBaselineCommit());
        CommitDescriptor end = this.resolve(timeIntervalOptions.getEndCommit());
        StringBuilder result = new StringBuilder();
        result.append("Start Timestamp").append(';');
        result.append("End Timestamp").append(';');
        result.append("Number of impacted tests").append("\n");
        for (long intervalStartTimestamp = baseline.getTimestamp(); intervalStartTimestamp < end.getTimestamp(); intervalStartTimestamp += (long)interval) {
            long intervalEndTimestamp = Math.min(intervalStartTimestamp + (long)interval, end.getTimestamp());
            HistoryAccessOption historyAccessOption = HistoryAccessOption.readTimestamp((String)end.getBranchName(), (long)intervalEndTimestamp);
            ImpactedTestsIndex impactedTestsIndex = this.openProjectIndex(ImpactedTestsIndex.class, historyAccessOption);
            long finalIntervalStartTimestamp = intervalStartTimestamp;
            long numberOfImpactedTests = impactedTestsIndex.getAllImpactedTests().values().stream().filter(impactedTest -> impactedTest.isCodeChangeReasonAfter(finalIntervalStartTimestamp)).count();
            result.append(intervalStartTimestamp).append(';');
            result.append(intervalEndTimestamp).append(';');
            result.append(numberOfImpactedTests).append("\n");
        }
        String fileName = "impacted_tests_" + baseline.getTimestamp() + "_" + end.getTimestamp() + "_" + interval + ".csv";
        return ResponseUtils.getFileDownloadResponse((Object)result.toString(), (MediaType)MoreMediaTypes.TEXT_CSV_TYPE, (String)fileName);
    }
}

