/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user;

import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserGroupUtils;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.autocomplete.EntityFilterHelper;
import com.teamscale.service.autocomplete.PrefixPriorityComparator;
import com.teamscale.service.base.ElementListServiceBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/user-groups")
public class UserGroupService
extends ElementListServiceBase<UserGroup> {
    @GET
    @Operation(summary="Get all user groups", description="Retrieves all available user groups in the system.", tags={"Groups", "Users"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return groups visible to current user.")
    public List<UserGroup> getAllUserGroups() throws StorageException {
        return PermissionFilterUtils.getVisibleGroups(this.getPermissions(), this.getGroupIndex());
    }

    @GET
    @Operation(summary="Get all user group names", description="Retrieves the names of all available user groups in the system.", tags={"Groups", "Users"})
    @Path(value="names")
    @RequiresNoPermission(description="No permissions needed, as the service will only return group names visible to current user.")
    public List<String> getAllUserGroupNames() throws StorageException {
        return CollectionUtils.map(PermissionFilterUtils.getVisibleGroups(this.getPermissions(), this.getGroupIndex()), UserGroup::getName);
    }

    @GET
    @RequiresBasicPermission(scope=EBasicPermissionScope.GROUPS, permissions={EBasicPermission.VIEW}, entityPathParameter="userGroupName")
    @Operation(summary="Get a user group", description="Get the user group identified by the given name.", tags={"Groups", "Users"}, responses={@ApiResponse(responseCode="404", description="User group with given name does not exist.")})
    @Path(value="{userGroupName}")
    public UserGroup getUserGroup(@Parameter(description="Name of the requested user group.") @PathParam(value="userGroupName") String userGroupName) throws StorageException {
        return (UserGroup)this.getElementWithExistsCheck(userGroupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @RequiresBasicPermission(scope=EBasicPermissionScope.GROUPS, permissions={EBasicPermission.DELETE}, entityPathParameter="userGroupName")
    @Operation(summary="Delete user group", description="Deletes the user group identified by the given name from the system", tags={"Groups", "Users"}, responses={@ApiResponse(responseCode="404", description="User group identified by the given name does not exist in the system.")})
    @Path(value="{userGroupName}")
    public void deleteUserGroup(@Parameter(description="Name of the user group to delete") @PathParam(value="userGroupName") String userGroupName) throws StorageException {
        UserGroupIndex groupIndex = (UserGroupIndex)this.getIndexLayer().openGlobalIndex(UserGroupIndex.class);
        Lock updateLock = groupIndex.getUpdateLock();
        updateLock.lock();
        try {
            UserGroup userGroup = (UserGroup)this.getElementWithExistsCheck(userGroupName);
            this.deleteElementAndPermissions(userGroup);
            AuditLogs.deleteUserGroup((String)userGroup.getName());
        }
        finally {
            updateLock.unlock();
        }
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_GROUPS})
    @Operation(summary="Create user group", description="Creates new user group.", tags={"Groups", "Users"})
    public void createUserGroup(@RequestBody(required=true) UserGroup userGroup) throws StorageException {
        this.createElementAndPermissions(userGroup);
        AuditLogs.createUserGroup((String)userGroup.getName(), (UnmodifiableSet)userGroup.getUserNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @RequiresBasicPermission(scope=EBasicPermissionScope.GROUPS, permissions={EBasicPermission.EDIT}, entityPathParameter="oldUserGroupName")
    @Operation(summary="Update user group", description="Updates the user group identified by the given name with the value in the request body.", tags={"Groups", "Users"})
    @Path(value="{oldUserGroupName}")
    public void updateUserGroup(@RequestBody(required=true) UserGroup newUserGroup, @Parameter(description="Old name of the user group to change") @PathParam(value="oldUserGroupName") String oldUserGroupName) throws StorageException {
        UserGroupIndex groupIndex = (UserGroupIndex)this.getIndexLayer().openGlobalIndex(UserGroupIndex.class);
        Lock updateLock = groupIndex.getUpdateLock();
        updateLock.lock();
        try {
            UserGroup oldUserGroup = this.getElement(oldUserGroupName);
            this.updateElement(oldUserGroup, newUserGroup);
        }
        finally {
            updateLock.unlock();
        }
    }

    @GET
    @Path(value="find")
    @Operation(summary="Autocomplete user group name", tags={"Users"})
    @RequiresNoPermission
    public Collection<String> autocompleteUserGroup(@QueryParam(value="token") String searchQuery, @QueryParam(value="regex") boolean regex, @QueryParam(value="max_matches") @DefaultValue(value="50") int maxResults) throws StorageException {
        if (StringUtils.isEmpty((String)searchQuery)) {
            return Collections.emptyList();
        }
        List visibleUserGroupNames = CollectionUtils.map(this.getVisibleUserGroups(), UserGroup::getName);
        return new EntityFilterHelper().filter(visibleUserGroupNames, searchQuery, regex, maxResults, new PrefixPriorityComparator(searchQuery, regex)).collect(Collectors.toList());
    }

    @Override
    protected void createPermissions(UserGroup userGroup) throws StorageException {
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.GROUPS, userGroup.getName());
    }

    @Override
    protected UserGroup getElement(String userGroup) throws StorageException {
        return this.getGroupIndex().getUserGroup(userGroup);
    }

    @Override
    protected void updateElement(UserGroup oldUserGroup, UserGroup newUserGroup) throws StorageException {
        String oldUserGroupName = oldUserGroup.getName();
        String newUserGroupName = newUserGroup.getName();
        if (oldUserGroupName.equals("Administrators") && !newUserGroupName.equals("Administrators")) {
            throw new BadRequestException("The group Administrators can't be renamed.");
        }
        String currentUserName = this.getUser().getUsername();
        if (newUserGroupName.equals("Administrators") && oldUserGroup.getUserNames().contains((Object)currentUserName) && !newUserGroup.getUserNames().contains((Object)currentUserName)) {
            throw new BadRequestException("Users aren't allowed to remove themselves from the group Administrators.");
        }
        UserGroupUtils.updateGroupMembership((UserGroup)oldUserGroup, (UserGroup)newUserGroup, (UserIndex)((UserIndex)this.getIndexLayer().openGlobalIndex(UserIndex.class)), (UserGroupIndex)((UserGroupIndex)this.getIndexLayer().openGlobalIndex(UserGroupIndex.class)), (IMessageBroker)this.getIndexLayer().getMessageBroker());
        if (!oldUserGroupName.equals(newUserGroupName)) {
            PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
            permissionIndex.moveOrCopyGroupPermissions(oldUserGroupName, newUserGroupName, true);
            AuditLogs.renameGroup((String)oldUserGroupName, (String)newUserGroupName);
        }
        this.getGroupIndex().removeGroup(oldUserGroupName);
        this.getGroupIndex().setGroup(newUserGroup);
    }

    @Override
    protected void deleteElement(UserGroup userGroup) throws StorageException {
        String userGroupName = userGroup.getName();
        if (userGroupName.equals("Administrators")) {
            throw new BadRequestException("The group Administrators can't be deleted.");
        }
        UserGroupUtils.removeAllUsersFromGroup((UserGroup)userGroup, (UserIndex)this.getUserIndex(), (UserGroupIndex)this.getGroupIndex(), (IMessageBroker)this.serviceInfo.getMessageBroker());
        this.getGroupIndex().removeGroup(userGroupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createElement(UserGroup userGroup) throws StorageException {
        UserGroupIndex groupIndex = (UserGroupIndex)this.getIndexLayer().openGlobalIndex(UserGroupIndex.class);
        Lock updateLock = groupIndex.getUpdateLock();
        updateLock.lock();
        try {
            UserGroup value = groupIndex.getUserGroup(userGroup.getName());
            if (value != null) {
                throw new BadRequestException("Cannot create group " + userGroup.getName() + ", group does already exist");
            }
            UserGroupUtils.addToGroup((UserGroup)userGroup, (Set)userGroup.getUserNames(), (UserIndex)((UserIndex)this.getIndexLayer().openGlobalIndex(UserIndex.class)), (UserGroupIndex)((UserGroupIndex)this.getIndexLayer().openGlobalIndex(UserGroupIndex.class)), (IMessageBroker)this.getIndexLayer().getMessageBroker());
        }
        finally {
            updateLock.unlock();
        }
    }

    @Override
    protected void deletePermissions(UserGroup deletedGroup) throws StorageException {
        String groupName = deletedGroup.getName();
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.GROUPS, groupName);
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        permissionIndex.deleteProjectRolesForGroup(groupName);
    }

    private List<UserGroup> getVisibleUserGroups() throws StorageException {
        return PermissionFilterUtils.getVisibleGroups(this.getPermissions(), this.openGlobalIndex(UserGroupIndex.class));
    }

    private UserGroupIndex getGroupIndex() throws StorageException {
        return this.openGlobalIndex(UserGroupIndex.class);
    }

    private UserIndex getUserIndex() throws StorageException {
        return this.openGlobalIndex(UserIndex.class);
    }
}

