/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.apple;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.EIssueTracker;
import com.teamscale.core.authenticate.apple.EAppleEnvironment;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.utils.ProjectUtils;
import java.util.List;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.TestOnly;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@Option(id="apple.idms.a3.auth", name="Apple A3 Authentication", type=EOptionType.SERVER, multiOption=true, visibilityFeatureToggle=EFeatureToggle.ENABLE_APPLE_SPECIFIC_FEATURES, category=EOptionCategory.APPLE, orderingHint=100)
@IndexValueClass(containedInBackup=true)
public class AppleIdmsA3AuthOption
implements IOption {
    public static final String OPTION_ID = "apple.idms.a3.auth";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="context")
    @OptionFieldDescription(name="Context string", description="Context string negotiated for authentication with other application")
    public String context;
    @JsonProperty(value="oneTimeToken")
    @OptionFieldDescription(name="One time token", description="Whether to request an OTT from IdMS.")
    public boolean oneTimeToken;
    @JsonProperty(value="personId")
    @OptionFieldDescription(name="Person ID", description="The person ID, if any, associated with this message.")
    public @Nullable String personId;
    @JsonProperty(value="isUat")
    @OptionFieldDescription(name="UAT", description="Whether to authenticate for UAT with this A3 app.")
    public boolean isUat;
    @JsonProperty(value="otherApplicationId")
    @OptionFieldDescription(name="Other application ID", description="The application ID of the application to authenticate with.")
    private String otherApplicationId;
    @JsonProperty(value="radarBaseUrl")
    private @Nullable String radarBaseUrl;

    public AppleIdmsA3AuthOption() {
    }

    @TestOnly
    public AppleIdmsA3AuthOption(String otherApplicationId, String context, boolean oneTimeToken, @Nullable String personId, boolean isUat, @NonNull String radarBaseUrl) {
        this.otherApplicationId = otherApplicationId;
        this.context = context;
        this.oneTimeToken = oneTimeToken;
        this.personId = personId;
        this.isUat = isUat;
        this.radarBaseUrl = radarBaseUrl;
    }

    private static boolean isA3Connector(ConnectorConfiguration connectorConfiguration) {
        return connectorConfiguration.isIssueTrackerType(EIssueTracker.RADAR);
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        try {
            long appId = Long.parseLong(this.otherApplicationId);
            if (appId == 0L || StringUtils.isEmpty((String)this.context)) {
                return "Application ID and context may not be empty";
            }
        }
        catch (NumberFormatException e) {
            return "Application ID must be a valid number";
        }
        return null;
    }

    public long getOtherApplicationId() {
        return Long.parseLong(this.otherApplicationId);
    }

    @Override
    public void executedActionsBeforeDeletion(IndexLayer indexLayer, String optionId) throws StorageException {
        IOption.super.executedActionsBeforeDeletion(indexLayer, optionId);
        ProjectIndex projectIndex = indexLayer.openGlobalIndex(ProjectIndex.class);
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            List<ConnectorConfiguration> a3Connectors;
            ProjectConfiguration projectConfiguration = ProjectUtils.retrieveProjectConfig((IProjectId)projectInfo.getInternalId(), indexLayer);
            if (projectConfiguration == null || (a3Connectors = projectConfiguration.getConnectors().stream().filter(AppleIdmsA3AuthOption::isA3Connector).filter(connectorConfiguration -> optionId.equals(connectorConfiguration.getOptionValue("Apple A3 Option Identifier"))).toList()).isEmpty()) continue;
            throw new StorageException("Could not delete option '%s', as it is at least used by project: '%s'".formatted(optionId, projectInfo.getPrimaryPublicId()));
        }
    }

    public EAppleEnvironment getConfiguredEnvironment() {
        if (this.isUat) {
            return EAppleEnvironment.UAT;
        }
        return EAppleEnvironment.PROD;
    }

    public @Nullable String getRadarBaseUrlForTesting() {
        return this.radarBaseUrl;
    }
}

