/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.findings;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.findings.FindingsSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexUtils;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ConvenientStore;
import org.conqat.engine.persistence.store.util.KeyCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class FindingsIndexBase
extends IndexBase {
    protected FindingsIndexBase(IStore store) {
        super(store);
    }

    public void setFindings(String partition, String uniformPath, ArrayList<IndexFinding> findings, FindingsSchema findingsSchema) throws StorageException {
        FindingsIndexBase.checkValidLocation(uniformPath, findings);
        CodeScopeAware<FindingsSchema> findingsSchemasByCodeScopeName = CodeScopeAware.empty();
        if (findingsSchema != null) {
            findingsSchemasByCodeScopeName = CodeScopeAware.defaultCodeScopeWithValue(findingsSchema);
        }
        this.setFindings(partition, (PairList<String, ArrayList<IndexFinding>>)PairList.from((Object)uniformPath, FindingsIndexBase.adaptFindings(findings, findingsSchemasByCodeScopeName, null, CodeScopeName.DEFAULT)));
    }

    protected void setFindings(String partition, PairList<String, ArrayList<IndexFinding>> uniformPathsAndValues) throws StorageException {
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap((Set)CollectionUtils.unionSet(Collections.singletonList(partition), (Collection[])new Collection[]{uniformPathsAndValues.extractFirstList()}));
        this.addPartitions(Set.of(partition));
        PairList keysValues = new PairList();
        for (int i = 0; i < uniformPathsAndValues.size(); ++i) {
            byte[] key = FindingsIndexBase.makeAbbreviatedKey((Integer)abbreviationMap.get(partition), (Integer)abbreviationMap.get(uniformPathsAndValues.getFirst(i)));
            byte[] value = StorageUtils.serialize((Serializable)((Serializable)uniformPathsAndValues.getSecond(i)));
            keysValues.add((Object)key, (Object)value);
        }
        this.store.put(keysValues);
    }

    private void addPartitions(Set<String> partitionsToAdd) throws StorageException {
        PartitionIndexUtils.addStoredPartitions((ConvenientStore)this.store, partitionsToAdd);
    }

    private static byte[] makeAbbreviatedKey(int abbreviatedPartition, int abbreviatedUniformPath) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviatedPartition), ByteArrayUtils.intsToByteArray((int[])new int[]{abbreviatedUniformPath})});
    }

    @Deprecated
    public CounterSet<String> setFindings(String partition, PairList<String, ? extends List<IndexFinding>> findings, @Nullable FindingsSchema findingsSchema) throws StorageException {
        CodeScopeAware<CounterSet<String>> droppedFindingTypes;
        CodeScopeAware<FindingsSchema> codeScopeToFindingsSchemaMapping = CodeScopeAware.empty();
        if (findingsSchema != null) {
            codeScopeToFindingsSchemaMapping = CodeScopeAware.defaultCodeScopeWithValue(findingsSchema);
        }
        if (!(droppedFindingTypes = this.setFindings(partition, findings, codeScopeToFindingsSchemaMapping, null)).contains(CodeScopeAware.DEFAULT_CODE_SCOPE)) {
            return CounterSet.empty();
        }
        return droppedFindingTypes.getValue(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    public CodeScopeAware<CounterSet<String>> setFindings(String partition, PairList<String, ? extends List<IndexFinding>> findings, CodeScopeAware<FindingsSchema> codeScopeToFindingsSchemaMapping, @Nullable Map<String, CodeScopeName> uniformPathToCodeScopeMapping) throws StorageException {
        PairList adaptedFindings = new PairList(findings.size());
        CodeScopeAware<CounterSet<String>> droppedFindingTypes = CodeScopeAware.empty();
        for (int i = 0; i < findings.size(); ++i) {
            String uniformPath = (String)findings.getFirst(i);
            if (((List)findings.getSecond(i)).isEmpty()) {
                adaptedFindings.add((Object)uniformPath, new ArrayList());
                continue;
            }
            CodeScopeName codeScopeNameOfFindingLocationPath = null;
            if (uniformPathToCodeScopeMapping != null) {
                codeScopeNameOfFindingLocationPath = uniformPathToCodeScopeMapping.get(uniformPath);
            }
            FindingsIndexBase.checkValidLocation(uniformPath, (Collection)findings.getSecond(i));
            adaptedFindings.add((Object)uniformPath, FindingsIndexBase.adaptFindings((List)findings.getSecond(i), codeScopeToFindingsSchemaMapping, droppedFindingTypes, codeScopeNameOfFindingLocationPath));
        }
        this.setFindings(partition, (PairList<String, ArrayList<IndexFinding>>)adaptedFindings);
        return droppedFindingTypes;
    }

    @Deprecated
    public CounterSet<String> setFindings(Map<String, Map<String, ArrayList<IndexFinding>>> findingsWithPartition, FindingsSchema findingsSchema) throws StorageException {
        HashMap<String, Map<String, ArrayList<IndexFinding>>> adaptedFindingsWithPartition = HashMap.newHashMap(findingsWithPartition.size());
        HashSet<PartitionAndPath> partitionAndPathsToRemove = new HashSet<PartitionAndPath>();
        CounterSet droppedFindingTypes = new CounterSet();
        for (Map.Entry<String, Map<String, ArrayList<IndexFinding>>> entry : findingsWithPartition.entrySet()) {
            String partition = entry.getKey();
            Map<String, ArrayList<IndexFinding>> findings = entry.getValue();
            HashMap<String, ArrayList<IndexFinding>> adaptedFindings = HashMap.newHashMap(findings.size());
            for (Map.Entry<String, List<IndexFinding>> uniformPathAndFindings : FindingsIndexBase.groupByLocationPath(findings.values()).entrySet()) {
                String uniformPath2 = uniformPathAndFindings.getKey();
                FindingsIndexBase.checkValidLocation(uniformPath2, (Collection<IndexFinding>)uniformPathAndFindings.getValue());
                CodeScopeAware<FindingsSchema> findingsSchemasByCodeScopeName = CodeScopeAware.empty();
                if (findingsSchema != null) {
                    findingsSchemasByCodeScopeName = CodeScopeAware.defaultCodeScopeWithValue(findingsSchema);
                }
                adaptedFindings.put(uniformPath2, FindingsIndexBase.adaptFindings(uniformPathAndFindings.getValue(), findingsSchemasByCodeScopeName, CodeScopeAware.defaultCodeScopeWithValue(droppedFindingTypes), CodeScopeName.DEFAULT));
            }
            adaptedFindingsWithPartition.put(partition, adaptedFindings);
            findings.forEach((uniformPath, findingsForPath) -> {
                if (findingsForPath.isEmpty()) {
                    partitionAndPathsToRemove.add(new PartitionAndPath(partition, uniformPath));
                }
            });
        }
        this.setFindings(adaptedFindingsWithPartition);
        this.removeFindingsForPartitionsAndPaths(partitionAndPathsToRemove);
        return droppedFindingTypes;
    }

    private void setFindings(Map<String, Map<String, ArrayList<IndexFinding>>> uniformPathsAndValuesWithPartition) throws StorageException {
        PairList keysValues = new PairList();
        Set<String> partitions = uniformPathsAndValuesWithPartition.keySet();
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap((Set)CollectionUtils.unionSet(partitions, (Collection[])new Collection[]{uniformPathsAndValuesWithPartition.values().stream().map(Map::keySet).flatMap(Collection::stream).collect(Collectors.toSet())}));
        for (Map.Entry<String, Map<String, ArrayList<IndexFinding>>> uniformPathsAndValuesPerPartition : uniformPathsAndValuesWithPartition.entrySet()) {
            String partition = uniformPathsAndValuesPerPartition.getKey();
            Map<String, ArrayList<IndexFinding>> uniformPathsAndValues = uniformPathsAndValuesPerPartition.getValue();
            for (Map.Entry<String, ArrayList<IndexFinding>> uniformPathAndValue : uniformPathsAndValues.entrySet()) {
                byte[] key = FindingsIndexBase.makeAbbreviatedKey((Integer)abbreviationMap.get(partition), (Integer)abbreviationMap.get(uniformPathAndValue.getKey()));
                byte[] value = StorageUtils.serialize((Serializable)uniformPathAndValue.getValue());
                keysValues.add((Object)key, (Object)value);
            }
        }
        this.addPartitions(partitions);
        this.store.put(keysValues);
    }

    private static Map<String, List<IndexFinding>> groupByLocationPath(Collection<ArrayList<IndexFinding>> findings) {
        return findings.stream().flatMap(Collection::stream).collect(Collectors.groupingBy(finding -> finding.getLocation().getUniformPath()));
    }

    private static void checkValidLocation(String uniformPath, Collection<IndexFinding> findings) {
        for (IndexFinding finding : findings) {
            CCSMAssert.isTrue((boolean)uniformPath.equals(finding.getLocation().getUniformPath()), (String)("Expected location of finding to be " + uniformPath + ", but was: " + finding.getLocation().getUniformPath()));
        }
    }

    private static ArrayList<IndexFinding> adaptFindings(List<IndexFinding> findings, CodeScopeAware<FindingsSchema> codeScopeToFindingsSchemaMapping, CodeScopeAware<CounterSet<String>> droppedFindingTypes, CodeScopeName codeScopeNameOfFindingLocationPath) {
        ArrayList<IndexFinding> result = new ArrayList<IndexFinding>();
        for (IndexFinding finding : findings) {
            FindingsSchema findingsSchema;
            CodeScopeName codeScopeName = finding.getCodeScopeName();
            if (codeScopeName == null) {
                codeScopeName = codeScopeNameOfFindingLocationPath;
            }
            if (codeScopeName == null) {
                codeScopeName = CodeScopeName.DEFAULT;
            }
            if ((findingsSchema = codeScopeToFindingsSchemaMapping.getValueOrNull(codeScopeName)) == null) {
                result.add(finding);
                continue;
            }
            IndexFinding adaptedFinding = findingsSchema.adaptFinding(finding);
            if (adaptedFinding != null) {
                result.add(adaptedFinding);
                continue;
            }
            if (droppedFindingTypes == null) continue;
            CounterSet droppedInCodeScope = droppedFindingTypes.getOrComputeValue(codeScopeName, scopeName -> new CounterSet());
            droppedInCodeScope.inc((Object)finding.getTypeId());
        }
        result.sort(IndexFinding.STABLE_INDEX_FINDING_COMPARATOR);
        return result;
    }

    public void removeFindingsForPartitionsAndPaths(String partition, List<String> uniformPaths) throws StorageException {
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap((Set)CollectionUtils.unionSet(uniformPaths, (Collection[])new Collection[]{Collections.singletonList(partition)}));
        this.store.remove(FindingsIndexBase.makeKeys((Integer)abbreviationMap.get(partition), CollectionUtils.map(uniformPaths, abbreviationMap::get)));
    }

    public void removeFindingsForPartitions(List<String> partitions) throws StorageException {
        ArrayList<byte[]> prefixes = new ArrayList<byte[]>(partitions.size());
        for (String partition : partitions) {
            prefixes.add(this.makePartitionKeyPrefix(partition));
        }
        ArrayList keys = new ArrayList();
        this.store.scanKeys(prefixes, (IKeyValueCallback)new KeyCollectingCallback(keys));
        this.store.remove(keys);
    }

    public void removeFindingsForPartitionsAndPaths(Collection<PartitionAndPath> partitionsAndUniformPaths) throws StorageException {
        ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>();
        HashSet allStrings = new HashSet();
        partitionsAndUniformPaths.forEach(partitionAndPath -> {
            allStrings.add(partitionAndPath.getPartition());
            allStrings.add(partitionAndPath.getUniformPath());
        });
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(allStrings);
        for (PartitionAndPath entry : partitionsAndUniformPaths) {
            keysToRemove.add(FindingsIndexBase.makeAbbreviatedKey((Integer)abbreviationMap.get(entry.getPartition()), (Integer)abbreviationMap.get(entry.getUniformPath())));
        }
        this.store.remove(keysToRemove);
    }

    public void removeFindingsFromAllPartitions(List<String> uniformPaths) throws StorageException {
        ArrayList<byte[]> deletionKeys = new ArrayList<byte[]>();
        List partitions = PartitionIndexUtils.getStoredPartitions((ConvenientStore)this.store);
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap((Set)CollectionUtils.unionSet(uniformPaths, (Collection[])new Collection[]{partitions}));
        for (String partition : partitions) {
            deletionKeys.addAll(FindingsIndexBase.makeKeys((Integer)abbreviationMap.get(partition), CollectionUtils.map(uniformPaths, abbreviationMap::get)));
        }
        this.store.remove(deletionKeys);
    }

    private static List<byte[]> makeKeys(int abbreviatedPartition, List<Integer> abbreviatedUniformPaths) {
        byte[] partition = ByteArrayUtils.intToByteArray((int)abbreviatedPartition);
        return CollectionUtils.map(abbreviatedUniformPaths, abbreviatedPath -> {
            byte[] path = ByteArrayUtils.intToByteArray((int)abbreviatedPath);
            return ByteArrayUtils.concat((byte[][])new byte[][]{partition, path});
        });
    }

    @VisibleForTesting
    public PairList<String, List<IndexFinding>> getAllUniformPathsAndFindings() throws StorageException {
        byte[] abbreviatedPartition = ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate("#-#partition-list#-#"));
        List<byte[]> keys = StorageUtils.listKeys((IStore)this.store).stream().filter(key -> !ByteArrayUtils.isPrefix((byte[])abbreviatedPartition, (byte[])key)).toList();
        return this.getUniformPathsAndFindingsForKeys(keys);
    }

    private PairList<String, List<IndexFinding>> getUniformPathsAndFindingsForKeys(List<byte[]> keys) throws StorageException {
        Set allKeyAsInts = CollectionUtils.mapToSet(keys, ByteArrayUtils::readIntFromStartOfArray);
        List uniformPathsAsInts = CollectionUtils.map(keys, key -> ByteArrayUtils.getIntFromByteArray((byte[])key, (int)4));
        allKeyAsInts.addAll(uniformPathsAsInts);
        Map unabbreviationMap = this.store.getAbbreviator().buildUnabbreviationMap(allKeyAsInts);
        List findingLists = StorageUtils.deserializeValues((List)this.store.get(keys));
        PairList result = new PairList();
        for (int i = 0; i < uniformPathsAsInts.size(); ++i) {
            result.add((Object)((String)unabbreviationMap.get(uniformPathsAsInts.get(i))), (Object)((List)findingLists.get(i)));
        }
        return result;
    }

    public ArrayList<IndexFinding> getFindings(String partition, String uniformPath) throws StorageException {
        return this.getFindings(partition, Collections.singletonList(uniformPath)).get(0);
    }

    public List<@Nullable ArrayList<IndexFinding>> getFindings(String partition, List<String> uniformPaths) throws StorageException {
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap((Set)CollectionUtils.unionSet(uniformPaths, (Collection[])new Collection[]{Collections.singletonList(partition)}));
        return StorageUtils.deserializeValues((List)this.store.get(FindingsIndexBase.makeKeys((Integer)abbreviationMap.get(partition), CollectionUtils.map(uniformPaths, abbreviationMap::get))));
    }

    @VisibleForTesting
    public PairList<String, List<IndexFinding>> getFindingsInPartition(String partition) throws StorageException {
        byte[] abbreviatedPartition = ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(partition));
        List<byte[]> keys = StorageUtils.listKeys((IStore)this.store).stream().filter(key -> ByteArrayUtils.isPrefix((byte[])abbreviatedPartition, (byte[])key)).toList();
        return this.getUniformPathsAndFindingsForKeys(keys);
    }

    private byte[] makePartitionKeyPrefix(String partition) throws StorageException {
        return ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate(partition));
    }

    public List<ArrayList<IndexFinding>> getFindingsForUniformPath(String partition, List<UniformPath> uniformPaths) throws StorageException {
        return this.getFindings(partition, CollectionUtils.map(uniformPaths, UniformPath::toString));
    }

    private String[] unabbreviateSingleKey(byte[] key) throws StorageException {
        int[] abbreviatedKeyParts = FindingsIndexBase.splitRawKey(key);
        String partition = this.store.getAbbreviator().unabbreviate(abbreviatedKeyParts[0]);
        String uniformPath = this.store.getAbbreviator().unabbreviate(abbreviatedKeyParts[1]);
        return new String[]{partition, uniformPath};
    }

    private static int[] splitRawKey(byte[] rawKey) {
        CCSMAssert.isTrue((rawKey.length == 8 ? 1 : 0) != 0, (String)"Expected key size to be exactly 8 bytes (two integers)");
        return new int[]{ByteArrayUtils.readIntFromStartOfArray((byte[])rawKey), ByteArrayUtils.getIntFromByteArray((byte[])rawKey, (int)4)};
    }

    public List<PartitionAndPath> getPartitionAndPathsForRawKeys(List<byte[]> rawKeys) throws StorageException {
        byte[] partitionMarkerPrefix = ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate("#-#partition-list#-#"));
        ArrayList<PartitionAndPath> result = new ArrayList<PartitionAndPath>();
        for (byte[] rawKey : rawKeys) {
            if (Arrays.equals(rawKey, partitionMarkerPrefix)) continue;
            String[] partitionAndPath = this.unabbreviateSingleKey(rawKey);
            result.add(new PartitionAndPath(partitionAndPath[0], partitionAndPath[1]));
        }
        return result;
    }

    @VisibleForTesting
    public byte[] makeRawKey(String partition, String uniformPath) throws StorageException {
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(new HashSet<String>(Arrays.asList(uniformPath, partition)));
        return FindingsIndexBase.makeKeys((Integer)abbreviationMap.get(partition), Collections.singletonList((Integer)abbreviationMap.get(uniformPath))).get(0);
    }

    public ListMap<String, String> buildPartitionPathMapForRawKeys(List<byte[]> keys) throws StorageException {
        byte[] partitionKey = ByteArrayUtils.intToByteArray((int)this.store.getAbbreviator().abbreviate("#-#partition-list#-#"));
        List keysAsIntPairs = CollectionUtils.mapWithException((Collection)CollectionUtils.filter(keys, key -> !ByteArrayUtils.isPrefix((byte[])partitionKey, (byte[])key)), FindingsIndexBase::splitRawKey);
        Set allKeys = keysAsIntPairs.stream().flatMapToInt(Arrays::stream).boxed().collect(Collectors.toSet());
        Map intsToFullStrings = this.store.getAbbreviator().buildUnabbreviationMap(allKeys);
        ListMap uniformPathsByPartitions = new ListMap();
        for (int[] keysAsIntPair : keysAsIntPairs) {
            uniformPathsByPartitions.add((Object)((String)intsToFullStrings.get(keysAsIntPair[0])), (Object)((String)intsToFullStrings.get(keysAsIntPair[1])));
        }
        return uniformPathsByPartitions;
    }
}

