/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.jspecify.annotations.NonNull;

public class AuditLogs {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String THREAD_CONTEXT_USERNAME_FIELD = "username";
    private static final String THREAD_CONTEXT_CLEAR_USERNAME_FIELD = "clearUsername";
    private static final ThreadLocal<Map<String, String>> ANONYMIZED_TO_CLEAR_USERNAME = ThreadLocal.withInitial(HashMap::new);
    private static final Set<EBasicPermission> LOGGED_FAILED_BASIC_PERMISSIONS = CollectionUtils.asUnmodifiable(EnumSet.of(EBasicPermission.EDIT_ROLES));
    private static final Set<EGlobalPermission> LOGGED_FAILED_GLOBAL_PERMISSIONS = CollectionUtils.asUnmodifiable(EnumSet.of(EGlobalPermission.EDIT_ROLES, EGlobalPermission.EDIT_GLOBAL_ROLES, EGlobalPermission.CREATE_USERS, EGlobalPermission.CREATE_GROUPS));
    private static final Set<EProjectPermission> LOGGED_FAILED_PROJECT_PERMISSIONS = CollectionUtils.asUnmodifiable(EnumSet.of(EProjectPermission.EDIT_ROLES));

    public static void userAuthentication(String username) {
        LOGGER.info("User {} has been successfully authenticated.", (Object)StringEscapeUtils.escapeJava((String)username));
    }

    public static void failedUserAuthentication(String username) {
        LOGGER.info("User {} has failed to authenticate.", (Object)StringEscapeUtils.escapeJava((String)username));
    }

    public static void userLogout(String username) {
        LOGGER.info("User {} successfully logged out", (Object)StringEscapeUtils.escapeJava((String)username));
    }

    public static void accessKeyCreated(String username) {
        AuditLogs.logWithUsername("Created access key for user " + username);
    }

    public static void accessKeysRemoved(String username, int count) {
        AuditLogs.logWithUsername("Removed " + count + " access key(s) for user " + username);
    }

    public static void globalLogDeletion(String logName) {
        AuditLogs.logWithUsername("Deleted global " + logName);
    }

    public static void projectLogDeletion(String logName, PublicProjectId projectId) {
        AuditLogs.logWithUsername("Deleted " + logName + " of project " + String.valueOf(projectId));
    }

    public static void passwordChanged(@NonNull String username) {
        AuditLogs.logWithUsername("Changed password for user " + username);
    }

    public static void createNewUser(@NonNull String username) {
        AuditLogs.logWithUsername("Created user " + username);
    }

    public static void deleteUser(@NonNull String username) {
        AuditLogs.logWithUsername("Deleted user " + username);
    }

    public static void addUserToGroup(@NonNull String username, String groupName) {
        AuditLogs.logWithUsername("Added user " + username + " to group " + groupName);
    }

    public static void removeUserFromGroup(@NonNull String username, String groupName) {
        AuditLogs.logWithUsername("Removed user " + username + " from group " + groupName);
    }

    public static void createUserGroup(String name, UnmodifiableSet<String> userNames) {
        AuditLogs.logWithUsername("Created user group " + name + " with initial users " + String.valueOf(userNames));
    }

    public static void deleteUserGroup(String name) {
        AuditLogs.logWithUsername("Deleted user group " + name);
    }

    public static void renameGroup(String oldUserGroupName, String newUserGroupName) {
        AuditLogs.logWithUsername("Renamed user group " + oldUserGroupName + " to " + newUserGroupName);
    }

    public static void backupCreated(String id) {
        AuditLogs.logWithUsername("Created backup with id " + id);
    }

    public static void backupImported(String backupId) {
        AuditLogs.logWithUsername("Imported backup with id " + backupId);
    }

    public static void deletedServerOption(String optionId) {
        AuditLogs.logWithUsername("Deleted server option " + optionId);
    }

    public static void editServerOptions() {
        AuditLogs.logWithUsername("Edited server options");
    }

    public static void projectDeleted(String projectId) {
        AuditLogs.logWithUsername("Deleted project " + projectId);
    }

    public static void createdProject(String projectId) {
        AuditLogs.logWithUsername("Created project " + projectId);
    }

    public static void projectConfigChanged(String projectId, boolean reanalysis) {
        if (reanalysis) {
            AuditLogs.logWithUsername("Changed project configuration of project " + projectId + ", which triggered a re-analysis");
        } else {
            AuditLogs.logWithUsername("Changed project configuration of project " + projectId + " without re-analysis");
        }
    }

    public static void reanalysisTriggered(String projectId) {
        AuditLogs.logWithUsername("Triggered re-analysis for project " + projectId);
    }

    public static void permissionUpdate(String updateMessage) {
        AuditLogs.logWithUsername(updateMessage);
    }

    public static void failedBasicPermissionCheck(EBasicPermission permission, String message) {
        if (LOGGED_FAILED_BASIC_PERMISSIONS.contains(permission)) {
            AuditLogs.logWithUsername(message);
        }
    }

    public static void failedGlobalPermissionCheck(EGlobalPermission permission, String message) {
        if (LOGGED_FAILED_GLOBAL_PERMISSIONS.contains(permission)) {
            AuditLogs.logWithUsername(message);
        }
    }

    public static void failedProjectPermissionCheck(EProjectPermission permission, String message) {
        if (LOGGED_FAILED_PROJECT_PERMISSIONS.contains(permission)) {
            AuditLogs.logWithUsername(message);
        }
    }

    private static void logWithUsername(String message) {
        try {
            String username = ThreadContext.get((String)THREAD_CONTEXT_USERNAME_FIELD);
            if (username == null) {
                message = (String)message + " (system job)";
            } else {
                String clearUsername = ANONYMIZED_TO_CLEAR_USERNAME.get().getOrDefault(username, username);
                ThreadContext.put((String)THREAD_CONTEXT_CLEAR_USERNAME_FIELD, (String)clearUsername);
                message = (String)message + " (acting user: " + clearUsername + ")";
            }
            LOGGER.info((String)message);
        }
        finally {
            ThreadContext.remove((String)THREAD_CONTEXT_CLEAR_USERNAME_FIELD);
        }
    }

    public static void registerDeanonymizationHint(@NonNull String anonymousUsername, @NonNull String originalUsername) {
        ANONYMIZED_TO_CLEAR_USERNAME.get().put(anonymousUsername, originalUsername);
    }
}

