/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.worker;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.core.log.worker.WorkerLogData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class WorkerLogDigestIndexBase
extends IndexBase
implements IRollbackableIndex {
    private static final byte[] DIGEST_PREFIX = new byte[]{100};
    private static final byte[] TIMESTAMP_PREFIX = new byte[]{116};
    private static final String LOCK_NAME = "lock";
    private static final String GENERIFIED_COMMIT_DESCRIPTOR = "<COMMIT_DESCRIPTOR>";

    protected WorkerLogDigestIndexBase(IStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertDigestForLogEntry(WorkerLogData workerLogData) throws StorageException {
        ShortWorkerLog shortWorkerLog = workerLogData.shortWorkerLog;
        byte[] digest = WorkerLogDigestIndexBase.createDigest(shortWorkerLog, workerLogData.detailedWorkerLog);
        Lock lock = this.store.obtainLock(LOCK_NAME);
        lock.lock();
        try {
            ArrayList<Long> timestamps = (ArrayList<Long>)StorageUtils.deserialize((byte[])this.store.get(WorkerLogDigestIndexBase.makeDigestKey(digest)));
            if (timestamps == null) {
                timestamps = new ArrayList<Long>();
            }
            timestamps.add(shortWorkerLog.getTimestamp());
            Collections.sort(timestamps);
            this.store.put(WorkerLogDigestIndexBase.makeDigestKey(digest), StorageUtils.serialize(timestamps));
            this.store.put(WorkerLogDigestIndexBase.makeTimestampKey(shortWorkerLog.getTimestamp()), digest);
        }
        finally {
            lock.unlock();
        }
    }

    private static byte[] createDigest(ShortWorkerLog shortWorkerLog, DetailedWorkerLog detailedLog) {
        Hasher hasher = Hashing.murmur3_128().newHasher();
        hasher.putUnencodedChars((CharSequence)shortWorkerLog.getTriggerName());
        hasher.putInt(shortWorkerLog.getLogCount().error());
        hasher.putInt(shortWorkerLog.getLogCount().fatal());
        if (detailedLog == null) {
            return hasher.hash().asBytes();
        }
        hasher.putUnencodedChars((CharSequence)WorkerLogDigestIndexBase.generifyCommitDescriptor(detailedLog.getSchedulingReason()));
        List<LoggingEventTransport> sortedUniqueEvents = WorkerLogDigestIndexBase.clusterLogEvents(detailedLog.getLoggingEvents());
        for (LoggingEventTransport loggingEvent : sortedUniqueEvents) {
            hasher.putInt(loggingEvent.getLevel().ordinal());
            hasher.putUnencodedChars((CharSequence)loggingEvent.getMessage());
        }
        return hasher.hash().asBytes();
    }

    private static List<LoggingEventTransport> clusterLogEvents(UnmodifiableList<LoggingEventTransport> loggingEvents) {
        HashSet<LoggingEventTransport> loggingEventTransports = new HashSet<LoggingEventTransport>();
        for (LoggingEventTransport event : loggingEvents) {
            if (!event.getLevel().getLog4JLevel().isMoreSpecificThan(Level.WARN)) continue;
            loggingEventTransports.add(event.withMessageBy(WorkerLogDigestIndexBase::generifyMessage));
        }
        return loggingEventTransports.stream().sorted(Comparator.comparing(LoggingEventTransport::getMessage)).toList();
    }

    @VisibleForTesting
    static String generifyMessage(String message) {
        if (!message.contains("\tat")) {
            return WorkerLogDigestIndexBase.generifyCommitDescriptor(message);
        }
        return message.lines().filter(line -> line.stripIndent().startsWith("at ")).collect(Collectors.joining("\n"));
    }

    @VisibleForTesting
    static String generifyCommitDescriptor(String completeMessage) {
        completeMessage = WorkerLogDigestIndexBase.generifyCommitDescriptor(completeMessage, '@');
        return WorkerLogDigestIndexBase.generifyCommitDescriptor(completeMessage, ':');
    }

    private static String generifyCommitDescriptor(String message, char indicator) {
        int indicatorIndex = message.indexOf(indicator);
        if (indicatorIndex == -1) {
            return message;
        }
        StringBuilder generifiedMessage = new StringBuilder(message.length());
        int latestSplit = 0;
        while (indicatorIndex != -1) {
            int endIndex = WorkerLogDigestIndexBase.getCommitDescriptorEndIndex(message, indicatorIndex);
            if (endIndex == -1) {
                indicatorIndex = message.indexOf(indicator, indicatorIndex + 1);
                continue;
            }
            int startIndex = WorkerLogDigestIndexBase.getCommitDescriptorStartIndex(message, latestSplit, indicatorIndex);
            if (startIndex == -1) {
                indicatorIndex = message.indexOf(indicator, endIndex);
                continue;
            }
            generifiedMessage.append(message, latestSplit, startIndex).append(GENERIFIED_COMMIT_DESCRIPTOR);
            latestSplit = endIndex;
            indicatorIndex = message.indexOf(indicator, endIndex);
        }
        if (latestSplit == 0) {
            return message;
        }
        generifiedMessage.append(message, latestSplit, message.length());
        return generifiedMessage.toString();
    }

    private static int getCommitDescriptorStartIndex(String message, int latestSplit, int indicatorIndex) {
        int currentIndex;
        if (indicatorIndex <= 0 || Character.isWhitespace(message.charAt(indicatorIndex - 1))) {
            return -1;
        }
        for (currentIndex = indicatorIndex - 1; currentIndex > latestSplit && !Character.isWhitespace(message.charAt(currentIndex - 1)); --currentIndex) {
        }
        return currentIndex;
    }

    private static int getCommitDescriptorEndIndex(String message, int indicatorIndex) {
        if (indicatorIndex >= message.length() - 1 || !Character.isDigit(message.charAt(indicatorIndex + 1))) {
            return -1;
        }
        int numberOfDigits = 0;
        int currentIndex = indicatorIndex + 1;
        while (currentIndex < message.length() && Character.isDigit(message.charAt(currentIndex))) {
            ++currentIndex;
            ++numberOfDigits;
        }
        if (numberOfDigits < 6) {
            return -1;
        }
        return currentIndex;
    }

    public ListMap<Long, Long> getOccurrences(List<ShortWorkerLog> logs) throws StorageException {
        List timestampKeys = CollectionUtils.map(logs, logEntry -> WorkerLogDigestIndexBase.makeTimestampKey(logEntry.getTimestamp()));
        List digests = this.store.get(timestampKeys);
        ArrayList<byte[]> nonNullDigests = new ArrayList<byte[]>();
        ArrayList<Long> nonNullTimestamps = new ArrayList<Long>();
        for (int i = 0; i < digests.size(); ++i) {
            byte[] digest = (byte[])digests.get(i);
            if (digest == null) continue;
            nonNullDigests.add(digest);
            nonNullTimestamps.add(logs.get(i).getTimestamp());
        }
        List digestKeys = CollectionUtils.map(nonNullDigests, WorkerLogDigestIndexBase::makeDigestKey);
        List occurrencesList = this.store.get(digestKeys);
        ListMap occurrencesMap = new ListMap();
        for (int i = 0; i < occurrencesList.size(); ++i) {
            List occurrences = (List)((Object)StorageUtils.deserialize((byte[])((byte[])occurrencesList.get(i))));
            if (occurrences == null) continue;
            occurrencesMap.addAll((Object)((Long)nonNullTimestamps.get(i)), (Collection)occurrences);
        }
        return occurrencesMap;
    }

    private static byte[] makeDigestKey(byte[] digest) {
        Preconditions.checkNotNull((Object)digest);
        return ByteArrayUtils.concat((byte[][])new byte[][]{DIGEST_PREFIX, digest});
    }

    private static byte[] makeTimestampKey(long timestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{TIMESTAMP_PREFIX, ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeRemovedEntries(LogIndexBase<ShortWorkerLog, DetailedWorkerLog> referenceLogIndex) throws StorageException {
        Lock lock = this.store.obtainLock(LOCK_NAME);
        lock.lock();
        try {
            List digestKeys = StorageUtils.listKeysStartingWith((byte[])DIGEST_PREFIX, (IStore)this.store);
            List timestampLists = StorageUtils.deserializeValues((List)this.store.get(digestKeys));
            Set<Long> timestampsToPurge = WorkerLogDigestIndexBase.computeTimestampsToPurge(referenceLogIndex, timestampLists);
            this.store.remove(CollectionUtils.map(timestampsToPurge, WorkerLogDigestIndexBase::makeTimestampKey));
            PairList updatedTimestamps = new PairList();
            HashSet<StorageKey> digestKeysToPurge = new HashSet<StorageKey>();
            for (int i = 0; i < digestKeys.size(); ++i) {
                ArrayList timestamps = (ArrayList)timestampLists.get(i);
                timestamps.removeIf(timestampsToPurge::contains);
                byte[] digestKey = (byte[])digestKeys.get(i);
                if (timestamps.isEmpty()) {
                    digestKeysToPurge.add(new StorageKey(digestKey));
                    continue;
                }
                updatedTimestamps.add((Object)digestKey, (Object)StorageUtils.serialize((Serializable)timestamps));
            }
            this.store.put(updatedTimestamps);
            this.store.remove(CollectionUtils.map(digestKeysToPurge, StorageKey::getKey));
        }
        finally {
            lock.unlock();
        }
    }

    private static Set<Long> computeTimestampsToPurge(LogIndexBase<ShortWorkerLog, DetailedWorkerLog> referenceLogIndex, List<ArrayList<Long>> timestampLists) throws StorageException {
        List<Long> uniqueTimestamps = timestampLists.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        List<ShortWorkerLog> shortLogs = referenceLogIndex.getShortLogs(uniqueTimestamps);
        HashSet<Long> timestampsToPurge = new HashSet<Long>();
        for (int i = 0; i < uniqueTimestamps.size(); ++i) {
            if (shortLogs.get(i) != null) continue;
            timestampsToPurge.add(uniqueTimestamps.get(i));
        }
        return timestampsToPurge;
    }
}

