/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.tfs;

import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.teamscale.core.tfs.ITfsVersionControlClient;
import com.teamscale.core.tfs.TfsException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

class TfsVersionControlClient
implements ITfsVersionControlClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private final VersionControlClient client;

    public TfsVersionControlClient(VersionControlClient client) {
        this.client = client;
    }

    @Override
    public List<String> getLatestChangeSetsWithNonEmptyComment(String path, int limit) {
        LinkedHashSet<Changeset> changesets = new LinkedHashSet<Changeset>();
        LatestVersionSpec to = LatestVersionSpec.INSTANCE;
        while (changesets.size() < limit) {
            LOGGER.info("Querying TFS for " + limit + " change sets on " + path + " until " + String.valueOf(to));
            Changeset[] retrievedChangesets = this.client.queryHistory(path, (VersionSpec)LatestVersionSpec.INSTANCE, 0, RecursionType.FULL, null, null, (VersionSpec)to, limit - changesets.size(), false, false, false, false);
            if (retrievedChangesets == null || retrievedChangesets.length == 0) break;
            LOGGER.info("Retrieved " + retrievedChangesets.length + " changesets");
            to = new ChangesetVersionSpec(retrievedChangesets[retrievedChangesets.length - 1].getChangesetID() - 1);
            for (Changeset changeset : retrievedChangesets) {
                if (StringUtils.isEmpty((String)changeset.getComment())) continue;
                changesets.add(changeset);
            }
        }
        LOGGER.info("Changesets: " + String.valueOf(CollectionUtils.map(changesets, Changeset::getChangesetID)));
        return changesets.stream().map(Changeset::getComment).toList();
    }

    @Override
    public void validateRepositoryAccess() throws TfsException {
        try {
            this.client.getConnection().ensureAuthenticated();
            this.client.getLatestChangesetID();
        }
        catch (RuntimeException e) {
            throw new TfsException(e);
        }
    }

    @Override
    public void validatePathSuffix(String pathSuffix) throws TfsException {
        try {
            this.client.getItem(pathSuffix);
        }
        catch (RuntimeException e) {
            throw new TfsException(e);
        }
    }

    @Override
    public List<String> listFilesForRepositoryPath(String basePath) {
        basePath = StringUtils.ensureEndsWith((String)basePath, (String)"/");
        ItemSet items = this.client.getItems(new ItemSpec(basePath, RecursionType.FULL), (VersionSpec)LatestVersionSpec.INSTANCE, DeletedState.NON_DELETED, ItemType.FILE, GetItemsOptions.NONE);
        ArrayList<String> files = new ArrayList<String>();
        for (Item item : items.getItems()) {
            String serverItem = item.getServerItem();
            String filePath = StringUtils.stripPrefixIgnoreCase((String)serverItem, (String)basePath);
            files.add(filePath);
        }
        return files;
    }
}

