/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.scm;

import java.io.File;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.scm.BlameCommand;
import org.sonar.api.batch.scm.IgnoreCommand;
import org.sonar.api.scanner.ScannerSide;

@ScannerSide
@ExtensionPoint
public abstract class ScmProvider {
    public abstract String key();

    public boolean supports(File baseDir) {
        return false;
    }

    public BlameCommand blameCommand() {
        throw new UnsupportedOperationException(this.formatUnsupportedMessage("Blame command"));
    }

    @CheckForNull
    public Set<Path> branchChangedFiles(String targetBranchName, Path rootBaseDir) {
        return null;
    }

    @CheckForNull
    public Map<Path, Set<Integer>> branchChangedLines(String targetBranchName, Path rootBaseDir, Set<Path> files) {
        return null;
    }

    @CheckForNull
    @Deprecated
    public Instant forkDate(String referenceBranchName, Path rootBaseDir) {
        return null;
    }

    public Path relativePathFromScmRoot(Path path) {
        throw new UnsupportedOperationException(this.formatUnsupportedMessage("Getting relative path from SCM root"));
    }

    public IgnoreCommand ignoreCommand() {
        throw new UnsupportedOperationException(this.formatUnsupportedMessage("Checking for ignored files"));
    }

    @CheckForNull
    public String revisionId(Path path) {
        throw new UnsupportedOperationException(this.formatUnsupportedMessage("Getting revision id"));
    }

    private String formatUnsupportedMessage(String prefix) {
        return prefix + " is not supported by " + this.key() + " provider";
    }
}

