/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.NewCodeMode;

public interface NewCodeDefinition {
    public static final String DATETIME_FORMAT = "MM/dd/yyyy HH:mm:ss";
    public static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");

    public NewCodeMode getMode();

    public boolean isOnNewCode(long var1);

    public boolean isSupported();

    public static String formatEpochToDate(long epoch) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epoch), ZoneId.systemDefault()).format(DATETIME_FORMATTER);
    }

    public static NewCodeDefinition withAlwaysNew() {
        return new NewCodeAlwaysNew();
    }

    public static NewCodeDefinition withNumberOfDays(int days, long thresholdDate) {
        return new NewCodeNumberOfDays(days, thresholdDate);
    }

    public static NewCodeDefinition withPreviousVersion(long thresholdDate, @Nullable String version) {
        return new NewCodePreviousVersion(thresholdDate, version);
    }

    public static NewCodeDefinition withReferenceBranch(String referenceBranch) {
        return new NewCodeReferenceBranch(referenceBranch);
    }

    public static NewCodeDefinition withSpecificAnalysis(long thresholdDate) {
        return new NewCodeSpecificAnalysis(thresholdDate);
    }

    public static class NewCodeAlwaysNew
    implements NewCodeDefinition {
        private NewCodeAlwaysNew() {
        }

        @Override
        public NewCodeMode getMode() {
            throw new UnsupportedOperationException("Mode shouldn't be called for this new code definition");
        }

        @Override
        public boolean isOnNewCode(long creationDate) {
            return true;
        }

        @Override
        public boolean isSupported() {
            return true;
        }
    }

    public static class NewCodeReferenceBranch
    implements NewCodeDefinition {
        private final String branchName;

        private NewCodeReferenceBranch(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public NewCodeMode getMode() {
            return NewCodeMode.REFERENCE_BRANCH;
        }

        @Override
        public boolean isOnNewCode(long creationDate) {
            return true;
        }

        @Override
        public boolean isSupported() {
            return false;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public String toString() {
            return "Current new code definition (reference branch) is not supported";
        }
    }

    public static class NewCodeSpecificAnalysis
    extends NewCodeDefinitionWithDate {
        private NewCodeSpecificAnalysis(long thresholdDate) {
            super(thresholdDate);
        }

        public String toString() {
            return String.format("Since analysis from %s", NewCodeDefinition.formatEpochToDate(this.thresholdDate));
        }

        @Override
        public NewCodeMode getMode() {
            return NewCodeMode.SPECIFIC_ANALYSIS;
        }
    }

    public static class NewCodePreviousVersion
    extends NewCodeDefinitionWithDate {
        private final String version;

        private NewCodePreviousVersion(long thresholdDate, @Nullable String version) {
            super(thresholdDate);
            this.version = version;
        }

        public String toString() {
            Object versionQualifier = this.version == null ? NewCodeDefinition.formatEpochToDate(this.thresholdDate) : "version " + this.version;
            return String.format("Since %s", versionQualifier);
        }

        @Override
        public NewCodeMode getMode() {
            return NewCodeMode.PREVIOUS_VERSION;
        }

        @CheckForNull
        public String getVersion() {
            return this.version;
        }
    }

    public static class NewCodeNumberOfDays
    extends NewCodeDefinitionWithDate {
        Integer days;

        private NewCodeNumberOfDays(Integer days, long thresholdDate) {
            super(thresholdDate);
            this.days = days;
        }

        public String toString() {
            return String.format("From last %s days", this.days);
        }

        @Override
        public NewCodeMode getMode() {
            return NewCodeMode.NUMBER_OF_DAYS;
        }

        public Integer getDays() {
            return this.days;
        }
    }

    public static abstract class NewCodeDefinitionWithDate
    implements NewCodeDefinition {
        protected final long thresholdDate;

        protected NewCodeDefinitionWithDate(long thresholdDate) {
            this.thresholdDate = thresholdDate;
        }

        @Override
        public boolean isOnNewCode(long creationDate) {
            return creationDate > this.thresholdDate;
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        public long getThresholdDate() {
            return this.thresholdDate;
        }
    }
}

