/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.hotspot;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.ChangeHotspotStatusParams;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.CheckLocalDetectionSupportedParams;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.CheckLocalDetectionSupportedResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.CheckStatusChangePermittedParams;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.CheckStatusChangePermittedResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.HotspotService;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.HotspotStatus;
import org.sonarsource.sonarlint.core.clientapi.backend.hotspot.OpenHotspotInBrowserParams;
import org.sonarsource.sonarlint.core.clientapi.client.OpenUrlInBrowserParams;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.hotspot.HotspotStatusChangeException;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationScope;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.EndpointParams;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.hotspot.HotspotApi;
import org.sonarsource.sonarlint.core.serverconnection.StoredServerInfo;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;

@Named
@Singleton
public class HotspotServiceImpl
implements HotspotService {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String NO_BINDING_REASON = "The project is not bound, please bind it to SonarQube 9.7+ or SonarCloud";
    private static final String UNSUPPORTED_SONARQUBE_REASON = "Security Hotspots detection is disabled with this version of SonarQube, please bind it to SonarQube 9.7+ or SonarCloud";
    private static final String REVIEW_STATUS_UPDATE_PERMISSION_MISSING_REASON = "Changing a hotspot's status requires the 'Administer Security Hotspot' permission.";
    private final SonarLintClient client;
    private final ConfigurationRepository configurationRepository;
    private final ConnectionConfigurationRepository connectionRepository;
    private final ServerApiProvider serverApiProvider;
    private final TelemetryServiceImpl telemetryService;
    private final StorageService storageService;

    public HotspotServiceImpl(SonarLintClient client, StorageService storageService, ConfigurationRepository configurationRepository, ConnectionConfigurationRepository connectionRepository, ServerApiProvider serverApiProvider, TelemetryServiceImpl telemetryService) {
        this.client = client;
        this.storageService = storageService;
        this.configurationRepository = configurationRepository;
        this.connectionRepository = connectionRepository;
        this.serverApiProvider = serverApiProvider;
        this.telemetryService = telemetryService;
    }

    @Override
    public void openHotspotInBrowser(OpenHotspotInBrowserParams params) {
        Optional<Binding> effectiveBinding = this.configurationRepository.getEffectiveBinding(params.getConfigScopeId());
        Optional endpointParams = effectiveBinding.flatMap(binding -> this.connectionRepository.getEndpointParams(binding.getConnectionId()));
        if (effectiveBinding.isEmpty() || endpointParams.isEmpty()) {
            LOG.warn("Configuration scope {} is not bound properly, unable to open hotspot", (Object)params.getConfigScopeId());
            return;
        }
        String url = HotspotServiceImpl.buildHotspotUrl(effectiveBinding.get().getSonarProjectKey(), params.getBranch(), params.getHotspotKey(), (EndpointParams)endpointParams.get());
        this.client.openUrlInBrowser(new OpenUrlInBrowserParams(url));
        this.telemetryService.hotspotOpenedInBrowser();
    }

    @Override
    public CompletableFuture<CheckLocalDetectionSupportedResponse> checkLocalDetectionSupported(CheckLocalDetectionSupportedParams params) {
        String configScopeId = params.getConfigScopeId();
        ConfigurationScope configScope = this.configurationRepository.getConfigurationScope(configScopeId);
        if (configScope == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("The provided configuration scope does not exist: " + configScopeId));
        }
        Optional<Binding> effectiveBinding = this.configurationRepository.getEffectiveBinding(configScopeId);
        if (effectiveBinding.isEmpty()) {
            return CompletableFuture.completedFuture(new CheckLocalDetectionSupportedResponse(false, NO_BINDING_REASON));
        }
        String connectionId = effectiveBinding.get().getConnectionId();
        AbstractConnectionConfiguration connection = this.connectionRepository.getConnectionById(connectionId);
        if (connection == null) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("The provided configuration scope is bound to an unknown connection: " + connectionId));
        }
        boolean supported = this.isLocalDetectionSupported(connection.getKind() == ConnectionKind.SONARCLOUD, effectiveBinding.get().getConnectionId());
        return CompletableFuture.completedFuture(new CheckLocalDetectionSupportedResponse(supported, supported ? null : UNSUPPORTED_SONARQUBE_REASON));
    }

    @Override
    public CompletableFuture<CheckStatusChangePermittedResponse> checkStatusChangePermitted(CheckStatusChangePermittedParams params) {
        String connectionId = params.getConnectionId();
        AbstractConnectionConfiguration connection = this.connectionRepository.getConnectionById(connectionId);
        Optional<ServerApi> serverApiOpt = this.serverApiProvider.getServerApi(connectionId);
        if (connection == null || serverApiOpt.isEmpty()) {
            return CompletableFuture.failedFuture(new IllegalArgumentException("Connection with ID '" + connectionId + "' does not exist"));
        }
        return serverApiOpt.get().hotspot().show(params.getHotspotKey()).thenApply(hotspot -> {
            List<HotspotReviewStatus> allowedStatuses = HotspotReviewStatus.allowedStatusesOn(connection.getKind());
            return HotspotServiceImpl.toResponse(hotspot.canChangeStatus, allowedStatuses);
        });
    }

    private static CheckStatusChangePermittedResponse toResponse(boolean canChangeStatus, List<HotspotReviewStatus> coreStatuses) {
        return new CheckStatusChangePermittedResponse(canChangeStatus, canChangeStatus ? null : REVIEW_STATUS_UPDATE_PERMISSION_MISSING_REASON, coreStatuses.stream().map(s -> HotspotStatus.valueOf(s.name())).sorted().collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> changeStatus(ChangeHotspotStatusParams params) {
        String configurationScopeId = params.getConfigurationScopeId();
        Optional<Binding> optionalBinding = this.configurationRepository.getEffectiveBinding(configurationScopeId);
        return optionalBinding.flatMap(effectiveBinding -> this.serverApiProvider.getServerApi(effectiveBinding.getConnectionId())).map(connection -> {
            HotspotReviewStatus reviewStatus = HotspotServiceImpl.toCore(params.getNewStatus());
            return ((CompletableFuture)connection.hotspot().changeStatusAsync(params.getHotspotKey(), reviewStatus).thenAccept(nothing -> {
                this.saveStatusInStorage((Binding)optionalBinding.get(), params.getHotspotKey(), reviewStatus);
                this.telemetryService.hotspotStatusChanged();
            })).exceptionally(throwable -> {
                throw new HotspotStatusChangeException((Throwable)throwable);
            });
        }).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private static HotspotReviewStatus toCore(HotspotStatus newStatus) {
        return HotspotReviewStatus.valueOf(newStatus.name());
    }

    private void saveStatusInStorage(Binding binding, String hotspotKey, HotspotReviewStatus newStatus) {
        this.storageService.binding(binding).findings().changeHotspotStatus(hotspotKey, newStatus);
    }

    private boolean isLocalDetectionSupported(boolean isSonarCloud, String connectionId) {
        return isSonarCloud || this.storageService.connection(connectionId).serverInfo().read().map(StoredServerInfo::getVersion).map(version -> version.compareToIgnoreQualifier(HotspotApi.TRACKING_COMPATIBLE_MIN_SQ_VERSION) >= 0).orElse(false) != false;
    }

    static String buildHotspotUrl(String projectKey, String branch, String hotspotKey, EndpointParams endpointParams) {
        String relativePath = (endpointParams.isSonarCloud() ? "/project/security_hotspots?id=" : "/security_hotspots?id=") + UrlUtils.urlEncode(projectKey) + "&branch=" + UrlUtils.urlEncode(branch) + "&hotspots=" + UrlUtils.urlEncode(hotspotKey);
        return ServerApiHelper.concat(endpointParams.getBaseUrl(), relativePath);
    }
}

