/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.List;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionExtractorBase;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class PythonConditionExtractor
extends ConditionExtractorBase {
    public PythonConditionExtractor() {
        super(EnumSet.of(ETokenType.AND, new ETokenType[]{ETokenType.OR, ETokenType.NOT, ETokenType.IS, ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.LT, ETokenType.GT, ETokenType.LTEQ, ETokenType.GTEQ}));
    }

    @Override
    protected boolean isDoubleOperator(ETokenType type1, ETokenType type2) {
        return type1 == ETokenType.LT && type2 == ETokenType.LT || type1 == ETokenType.GT && type2 == ETokenType.GT;
    }

    @Override
    public Condition extractCondition(ShallowEntity entity) {
        switch (entity.getSubtype()) {
            case "if": 
            case "elif": 
            case "while": {
                return PythonConditionExtractor.getConditionFromFirstLine(entity);
            }
        }
        return null;
    }

    private static Condition getConditionFromFirstLine(ShallowEntity entity) {
        UnmodifiableList ownStartTokens = entity.ownStartTokens();
        int end = TokenStreamUtils.firstTokenMatching((List)ownStartTokens, (ITokenMatcher)ETokenType.COLON);
        return new Condition((List<IToken>)ownStartTokens.subList(1, end));
    }
}

