/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.jsbuild.export.AnnotationBasedExporter;
import com.teamscale.jsbuild.export.ArrayFieldExporter;
import com.teamscale.jsbuild.export.EnumFieldExporter;
import com.teamscale.jsbuild.export.ExportTypeException;
import com.teamscale.jsbuild.export.ExportedTypeScriptClass;
import com.teamscale.jsbuild.export.FixedJsTypeExporter;
import com.teamscale.jsbuild.export.GeneralObjectExporter;
import com.teamscale.jsbuild.export.GenericCollectionFieldExporter;
import com.teamscale.jsbuild.export.MapFieldExporter;
import com.teamscale.jsbuild.export.PrimitiveExporter;
import com.teamscale.jsbuild.export.TypescriptType;
import com.teamscale.jsbuild.export.TypescriptTypeExporterBase;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.js_export.NotExported;

public class JavaToTypeScriptClassExporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<TypescriptTypeExporterBase> EXPORTER_CREATORS = CollectionUtils.asUnmodifiable(Arrays.asList(new AnnotationBasedExporter(), new PrimitiveExporter(), new FixedJsTypeExporter(), new EnumFieldExporter(), new ArrayFieldExporter(), new GenericCollectionFieldExporter(), new MapFieldExporter(), new GeneralObjectExporter()));

    public static TypescriptType getExportedType(Field field) throws ExportTypeException {
        return JavaToTypeScriptClassExporter.getExportedType(field.getType(), field.getAnnotatedType(), field);
    }

    private static TypescriptType getExportedType(Method method) {
        Class<?> returnType = method.getReturnType();
        return JavaToTypeScriptClassExporter.getExportedType(returnType, method.getAnnotatedReturnType(), method);
    }

    public static TypescriptType getExportedType(Class<?> clazz, AnnotatedType annotatedType, Member member) throws ExportTypeException {
        for (TypescriptTypeExporterBase exporterCreator : EXPORTER_CREATORS) {
            Optional<TypescriptType> exportedType = exporterCreator.resolveJavaScriptType(clazz, annotatedType, member);
            if (!exportedType.isPresent()) continue;
            return exportedType.get();
        }
        CCSMAssert.fail((String)("Unable to export type for: " + String.valueOf(member)));
        return null;
    }

    private static LinkedHashMap<String, TypescriptType> getFieldsAndMethodsWithType(Class<?> type) throws ExportTypeException {
        Field[] fields = type.getDeclaredFields();
        LinkedHashMap<String, TypescriptType> exportedFields = new LinkedHashMap<String, TypescriptType>();
        for (Field field : fields) {
            if (!JavaToTypeScriptClassExporter.shouldBeExported(field)) continue;
            if (field.isAnnotationPresent(JsonUnwrapped.class)) {
                Class<?> currentType = field.getType();
                do {
                    exportedFields.putAll(JavaToTypeScriptClassExporter.getFieldsAndMethodsWithType(currentType));
                } while ((currentType = JavaToTypeScriptClassExporter.getSuperclass(currentType)) != null);
                continue;
            }
            exportedFields.put(JavaToTypeScriptClassExporter.getExportedFieldName(field, type), JavaToTypeScriptClassExporter.getExportedType(field));
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!JavaToTypeScriptClassExporter.shouldBeExported((Method)accessibleObject)) continue;
            exportedFields.put(JavaToTypeScriptClassExporter.getExportedFieldName((Method)accessibleObject), JavaToTypeScriptClassExporter.getExportedType((Method)accessibleObject));
        }
        return exportedFields;
    }

    private static String getExportedFieldName(Field field, Class<?> type) {
        if (field.isAnnotationPresent(JsonProperty.class)) {
            String value = field.getAnnotation(JsonProperty.class).value();
            if (value.isEmpty()) {
                throw new IllegalStateException("@JsonProperty annotation expected to have a non-empty value in classes exported to JavaScript for " + field.getName() + " of class " + type.getSimpleName());
            }
            return value;
        }
        LOGGER.warn("Exported field " + field.getName() + " of class " + type.getSimpleName() + " is not annotated with @JsonProperty!");
        return field.getName();
    }

    private static String getExportedFieldName(Method method) {
        CCSMAssert.isTrue((boolean)method.isAnnotationPresent(JsonGetter.class), (String)("Unable to export type for method field: " + String.valueOf(method)));
        String value = method.getAnnotation(JsonGetter.class).value();
        if (value.isEmpty()) {
            throw new IllegalStateException("@JsonGetter annotation expected to have a non-empty value in classes exported to JavaScript");
        }
        return value;
    }

    private static boolean shouldBeExported(Field field) {
        return !JsonUtils.isNotSerialized((Field)field) && !field.isAnnotationPresent(NotExported.class) && !field.getName().equals("serialVersionUID") && !field.isAnnotationPresent(Deprecated.class);
    }

    private static boolean shouldBeExported(Method method) {
        return !method.isSynthetic() && !Modifier.isStatic(method.getModifiers()) && method.getName().startsWith("get") && method.isAnnotationPresent(JsonGetter.class) && !method.isAnnotationPresent(Deprecated.class);
    }

    public static Collection<ExportedTypeScriptClass> getExportedTypeScriptClasses(Collection<Class<?>> exportAnnotatedClasses) throws ExportTypeException {
        HashMap currentlyExportedClasses = new HashMap();
        for (Class<?> classInHierarchy : exportAnnotatedClasses) {
            CCSMAssert.isFalse((boolean)classInHierarchy.isEnum(), (String)"Expected no enums at this point");
            try {
                ExportedTypeScriptClass exportedClass = new ExportedTypeScriptClass(classInHierarchy, (PairList<String, TypescriptType>)PairList.fromMap(JavaToTypeScriptClassExporter.getFieldsAndMethodsWithType(classInHierarchy)), JavaToTypeScriptClassExporter.getSuperclass(classInHierarchy));
                currentlyExportedClasses.put(classInHierarchy, exportedClass);
            }
            catch (Exception e) {
                throw new ExportTypeException("Failed to export javascript for class " + classInHierarchy.getSimpleName(), e);
            }
        }
        return currentlyExportedClasses.values();
    }

    private static Class<?> getSuperclass(Class<?> classInHierarchy) {
        Class<?> superClass = classInHierarchy.getSuperclass();
        if (superClass != Object.class && !superClass.getName().equals("java.lang.Record")) {
            return superClass;
        }
        return null;
    }
}

