/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002\u001a \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"getCommonSuperInterfaces", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "superInterfaces", "otherType", "getDelegeeOrNull", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getFunctionSingleBodyElementOrNull", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getSuperInterfaces", "", "kotlinType", "isDelegatedParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "arguments", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "isEqualFunctionSignature", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isFunctionInInterface", "superInterface", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nDelegationPatternCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DelegationPatternCheck.kt\norg/sonarsource/kotlin/checks/DelegationPatternCheckKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionExtensions.kt\norg/sonarsource/kotlin/api/checks/CollectionExtensionsKt\n*L\n1#1,137:1\n1747#2,3:138\n1864#2,2:143\n1866#2:149\n766#2:152\n857#2,2:153\n1864#2,2:157\n1866#2:163\n28#3,2:141\n30#3,4:145\n34#3,2:150\n28#3,2:155\n30#3,4:159\n34#3,2:164\n*S KotlinDebug\n*F\n+ 1 DelegationPatternCheck.kt\norg/sonarsource/kotlin/checks/DelegationPatternCheckKt\n*L\n83#1:138,3\n94#1:143,2\n94#1:149\n102#1:152\n102#1:153,2\n113#1:157,2\n113#1:163\n94#1:141,2\n94#1:145,4\n94#1:150,2\n113#1:155,2\n113#1:159,4\n113#1:164,2\n*E\n"})
public final class DelegationPatternCheckKt {
    private static final boolean isFunctionInInterface(KtNamedFunction function2, KotlinType superInterface, BindingContext bindingContext2) {
        boolean bl;
        block4: {
            ClassDescriptor classDescriptor2 = TypeUtils.getClassDescriptor(superInterface);
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor2 instanceof ClassDescriptorWithResolutionScopes ? (ClassDescriptorWithResolutionScopes)classDescriptor2 : null;
            if (classDescriptorWithResolutionScopes == null) {
                return false;
            }
            ClassDescriptorWithResolutionScopes classDescriptor3 = classDescriptorWithResolutionScopes;
            Collection<CallableMemberDescriptor> collection = classDescriptor3.getDeclaredCallableMembers();
            Intrinsics.checkNotNullExpressionValue(collection, "getDeclaredCallableMembers(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    if (!DelegationPatternCheckKt.isEqualFunctionSignature(function2, it, bindingContext2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isEqualFunctionSignature(KtNamedFunction function2, CallableMemberDescriptor functionDescriptor, BindingContext bindingContext2) {
        KotlinType kotlinType;
        String string2;
        void $this$allPaired$iv;
        if (!Intrinsics.areEqual(function2.getName(), functionDescriptor.getName().getIdentifier())) return false;
        KotlinType kotlinType2 = functionDescriptor.getReturnType();
        if (!Intrinsics.areEqual(ApiExtensionsKt.returnTypeAsString$default(function2, bindingContext2, false, 2, null), kotlinType2 != null ? DescriptorUtilsKt.getKotlinTypeFqName(kotlinType2, false) : null)) return false;
        List<KtParameter> list2 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        List<KtParameter> list3 = list2;
        List<ValueParameterDescriptor> list4 = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list4, "getValueParameters(...)");
        List<ValueParameterDescriptor> other$iv = list4;
        boolean $i$f$allPaired = false;
        if ($this$allPaired$iv.size() != other$iv.size()) return false;
        void $this$allPaired_u24lambda_u241$iv = $this$allPaired$iv;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv$iv = (Iterable)$this$allPaired_u24lambda_u241$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        Iterator iterator2 = $this$forEachIndexed$iv$iv.iterator();
        do {
            void paramerterDescriptor;
            KtTypeReference ktTypeReference;
            void value$iv;
            int n;
            if (!iterator2.hasNext()) return true;
            Object item$iv$iv = iterator2.next();
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl2 = false;
            ValueParameterDescriptor valueParameterDescriptor = other$iv.get(index$iv);
            KtParameter parameter = (KtParameter)value$iv;
            boolean bl3 = false;
            KtTypeReference ktTypeReference2 = ktTypeReference = parameter.getTypeReference();
            if (ktTypeReference2 != null) {
                Intrinsics.checkNotNull(ktTypeReference2);
                string2 = ApiExtensionsKt.determineTypeAsString$default(ktTypeReference, bindingContext2, false, 2, null);
            } else {
                string2 = null;
            }
            kotlinType = paramerterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        } while (Intrinsics.areEqual(string2, DescriptorUtilsKt.getKotlinTypeFqName(kotlinType, false)));
        return false;
    }

    @NotNull
    public static final Set<KotlinType> getCommonSuperInterfaces(@NotNull Set<? extends KotlinType> superInterfaces, @NotNull KotlinType otherType) {
        Intrinsics.checkNotNullParameter(superInterfaces, "superInterfaces");
        Intrinsics.checkNotNullParameter(otherType, "otherType");
        return CollectionsKt.intersect((Iterable)DelegationPatternCheckKt.getSuperInterfaces(otherType), (Iterable)superInterfaces);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KotlinType> getSuperInterfaces(KotlinType kotlinType) {
        void var2_3;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = TypeUtilsKt.supertypes(kotlinType);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinType p0 = (KotlinType)element$iv$iv;
            boolean bl = false;
            if (!TypeUtilsKt.isInterface(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        return TypeUtilsKt.isInterface(kotlinType) ? CollectionsKt.plus((Collection)it, kotlinType) : var2_3;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final KtNameReferenceExpression getDelegeeOrNull(KtNamedFunction function2, BindingContext bindingContext2) {
        void $this$allPaired$iv;
        PsiElement psiElement = DelegationPatternCheckKt.getFunctionSingleBodyElementOrNull(function2);
        if (!(psiElement instanceof KtDotQualifiedExpression)) return null;
        KtDotQualifiedExpression ktDotQualifiedExpression = (KtDotQualifiedExpression)psiElement;
        if (ktDotQualifiedExpression == null) {
            return null;
        }
        KtDotQualifiedExpression qualifiedCallExpression = ktDotQualifiedExpression;
        Object object = qualifiedCallExpression.getReceiverExpression();
        if (!(object instanceof KtNameReferenceExpression)) return null;
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)object;
        if (ktNameReferenceExpression == null) {
            return null;
        }
        KtNameReferenceExpression receiverExpression = ktNameReferenceExpression;
        KtExpression ktExpression = qualifiedCallExpression.getSelectorExpression();
        if (!(ktExpression instanceof KtCallExpression)) return null;
        KtCallExpression ktCallExpression = (KtCallExpression)ktExpression;
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression = ktCallExpression;
        String string2 = function2.getName();
        Intrinsics.checkNotNull(string2);
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression(callExpression);
        if (!Intrinsics.areEqual(string2, ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null)) return null;
        if (!Intrinsics.areEqual(ApiExtensionsKt.returnType(function2, bindingContext2), ApiExtensionsKt.determineType(callExpression, bindingContext2))) return null;
        List<KtParameter> list2 = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        object = list2;
        List<KtValueArgument> list3 = callExpression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list3, "getValueArguments(...)");
        List<KtValueArgument> other$iv = list3;
        boolean $i$f$allPaired = false;
        if ($this$allPaired$iv.size() != other$iv.size()) return null;
        void $this$allPaired_u24lambda_u241$iv = $this$allPaired$iv;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv$iv = (Iterable)$this$allPaired_u24lambda_u241$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
            void argument;
            void value$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int index$iv = n;
            boolean bl2 = false;
            KtValueArgument ktValueArgument = other$iv.get(index$iv);
            KtParameter parameter = (KtParameter)value$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull(parameter);
            Intrinsics.checkNotNull(argument);
            if (DelegationPatternCheckKt.isDelegatedParameter(parameter, (KtValueArgument)argument, bindingContext2)) continue;
            return null;
        }
        boolean bl4 = true;
        if (!bl4) return null;
        KtNameReferenceExpression ktNameReferenceExpression2 = receiverExpression;
        return ktNameReferenceExpression2;
    }

    private static final boolean isDelegatedParameter(KtParameter parameter, KtValueArgument arguments2, BindingContext bindingContext2) {
        KtExpression ktExpression = arguments2.getArgumentExpression();
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression argumentExpression = ktNameReferenceExpression;
        return Intrinsics.areEqual(parameter.getName(), argumentExpression.getReferencedName()) && Intrinsics.areEqual(ApiExtensionsKt.determineType((PsiElement)parameter, bindingContext2), ApiExtensionsKt.determineType(argumentExpression, bindingContext2));
    }

    private static final PsiElement getFunctionSingleBodyElementOrNull(KtNamedFunction function2) {
        KtExpression bodyExpression = function2.getBodyExpression();
        if (!(bodyExpression instanceof KtBlockExpression)) {
            return bodyExpression;
        }
        PsiElement[] psiElementArray = ((KtBlockExpression)bodyExpression).getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
        PsiElement singleBodyElement = (PsiElement)ArraysKt.singleOrNull((Object[])psiElementArray);
        return singleBodyElement instanceof KtReturnExpression ? (PsiElement)((KtReturnExpression)singleBodyElement).getReturnedExpression() : singleBodyElement;
    }

    public static final /* synthetic */ List access$getSuperInterfaces(KotlinType kotlinType) {
        return DelegationPatternCheckKt.getSuperInterfaces(kotlinType);
    }

    public static final /* synthetic */ KtNameReferenceExpression access$getDelegeeOrNull(KtNamedFunction function2, BindingContext bindingContext2) {
        return DelegationPatternCheckKt.getDelegeeOrNull(function2, bindingContext2);
    }

    public static final /* synthetic */ boolean access$isFunctionInInterface(KtNamedFunction function2, KotlinType superInterface, BindingContext bindingContext2) {
        return DelegationPatternCheckKt.isFunctionInInterface(function2, superInterface, bindingContext2);
    }
}

