/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.frontend.KotlinFileContextKt;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.MergeIfElseIntoWhenCheckKt;

@Rule(key="S6511")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/sonarsource/kotlin/checks/MergeIfElseIntoWhenCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "threshold", "", "getThreshold", "()I", "setThreshold", "(I)V", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nMergeIfElseIntoWhenCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeIfElseIntoWhenCheck.kt\norg/sonarsource/kotlin/checks/MergeIfElseIntoWhenCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1549#2:77\n1620#2,3:78\n*S KotlinDebug\n*F\n+ 1 MergeIfElseIntoWhenCheck.kt\norg/sonarsource/kotlin/checks/MergeIfElseIntoWhenCheck\n*L\n48#1:77\n48#1:78,3\n*E\n"})
public final class MergeIfElseIntoWhenCheck
extends AbstractCheck {
    @RuleProperty(key="threshold", description="Number of \"if\" after which the chain should be replaced by a \"when\" statement.", defaultValue="3")
    private int threshold = 3;

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        PsiElement psiElement = expression2.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        if (!MergeIfElseIntoWhenCheckKt.access$isElseElement(psiElement) && MergeIfElseIntoWhenCheckKt.access$isIfChainLongerThanOrEqualThreshold(expression2, this.threshold)) {
            Collection<SecondaryLocation> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            AbstractCheck abstractCheck = this;
            PsiElement psiElement2 = expression2.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getIfKeyword(...)");
            Iterable iterable = MergeIfElseIntoWhenCheckKt.access$collectSecondaryIfStatements(expression2);
            String string2 = "Merge chained \"if\" statements into a single \"when\" statement.";
            PsiElement psiElement3 = psiElement2;
            KotlinFileContext kotlinFileContext = context;
            AbstractCheck abstractCheck2 = abstractCheck;
            boolean $i$f$map = false;
            void var5_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtIfExpression ktIfExpression = (KtIfExpression)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                PsiElement psiElement4 = it.getIfKeyword();
                Intrinsics.checkNotNullExpressionValue(psiElement4, "getIfKeyword(...)");
                collection.add(KotlinFileContextKt.secondaryOf(context, psiElement4, "Merge with first \"if\" statement."));
            }
            collection = (List)destination$iv$iv;
            AbstractCheck.reportIssue$default(abstractCheck2, kotlinFileContext, psiElement3, string2, (List)collection, null, 8, null);
        }
    }
}

