/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.jacoco;

import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import com.teamscale.reportparser.parser.jacoco.GeneratedJacocoParser;
import com.teamscale.reportparser.utils.UnsynchronizedStringReader;
import java.io.IOException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.string.StringUtils;

public class JaCoCoReportParser
extends CoverageReportParserBase {
    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever lineCoverageInfoRetriever) throws ReportParserException {
        Parser parser = new Parser(report, lineCoverageInfoRetriever);
        try {
            parser.parse();
        }
        catch (IOException e) {
            throw new ReportParserException(e);
        }
    }

    private static void checkValidReport(String report) throws ReportParserException {
        String reportStart = report.substring(0, Math.min(200, report.length()));
        if (!reportStart.contains("<report")) {
            throw new ReportParserException("Error parsing JaCoCo coverage report. Content starting with '" + StringUtils.truncateWithEllipsis((String)report, (int)100) + "'");
        }
    }

    public static class Parser
    extends GeneratedJacocoParser {
        private final CoverageInfoRetriever lineCoverageInfoRetriever;
        private LineCoverageInfo currentLineCoverage;

        public Parser(String report, CoverageInfoRetriever lineCoverageInfoRetriever) throws ReportParserException {
            super(new UnsynchronizedStringReader(report));
            JaCoCoReportParser.checkValidReport(report);
            this.lineCoverageInfoRetriever = lineCoverageInfoRetriever;
        }

        @Override
        protected void handleSourceFile(String fileName) {
            Object path = fileName;
            if (!StringUtils.isEmpty((String)this.currentPackage)) {
                path = this.currentPackage + "/" + (String)path;
            }
            this.currentLineCoverage = this.lineCoverageInfoRetriever.getOrCreateLineCoverageInfo((String)path);
        }

        @Override
        protected void handleLine(int lineNumber, boolean hasCoveredInstructions, boolean hasMissedInstructions, boolean hasMissedBranches) {
            if (hasCoveredInstructions && !hasMissedInstructions && !hasMissedBranches) {
                this.currentLineCoverage.addLineCoverage(lineNumber, ELineCoverage.FULLY_COVERED);
            } else if (hasCoveredInstructions) {
                this.currentLineCoverage.addLineCoverage(lineNumber, ELineCoverage.PARTIALLY_COVERED);
            } else if (hasMissedInstructions || hasMissedBranches) {
                this.currentLineCoverage.addLineCoverage(lineNumber, ELineCoverage.NOT_COVERED);
            }
        }
    }
}

