/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.comparison;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.index.admin.instance_comparison.comparison.EInstanceComparisonSummary;
import com.teamscale.index.admin.instance_comparison.comparison.FindingInstanceComparisonDiffEntry;
import com.teamscale.index.admin.instance_comparison.comparison.InstanceComparisonDiffEntryExamples;
import com.teamscale.index.admin.instance_comparison.comparison.PredefinedImprovedInstanceComparisonDiffEntry;
import java.io.Serializable;
import org.conqat.lib.commons.test.IndexValueClass;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FindingInstanceComparisonDiffEntry.class), @JsonSubTypes.Type(value=PredefinedImprovedInstanceComparisonDiffEntry.class)})
@IndexValueClass
public abstract class InstanceComparisonDiffEntryBase<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String NAME_PROPERTY = "name";
    protected static final String EXAMPLES_PROPERTY = "examples";
    protected static final String ONLY_IMPROVEMENT_PROPERTY = "onlyImprovement";
    protected static final String WITHIN_ACCEPTED_DEVIATIONS_PROPERTY = "withinAcceptedDeviations";
    protected static final String LOCAL_VALUE_PROPERTY = "localValue";
    protected static final String REMOTE_VALUE_PROPERTY = "remoteValue";
    protected static final String LOCAL_FINDINGS_COUNT_PROPERTY = "localFindingsCount";
    protected static final String REMOTE_FINDINGS_COUNT_PROPERTY = "remoteFindingsCount";
    @JsonProperty(value="name")
    protected final String name;
    @JsonProperty(value="examples")
    protected final InstanceComparisonDiffEntryExamples examples;
    @JsonProperty(value="localValue")
    protected final T localValue;
    @JsonProperty(value="remoteValue")
    protected final T remoteValue;
    @JsonProperty(value="withinAcceptedDeviations")
    protected final boolean withinAcceptedDeviations;

    protected InstanceComparisonDiffEntryBase(String name, InstanceComparisonDiffEntryExamples examples, T localValue, T remoteValue, boolean withinAcceptedDeviations) {
        this.name = name;
        this.examples = examples;
        this.localValue = localValue;
        this.remoteValue = remoteValue;
        this.withinAcceptedDeviations = withinAcceptedDeviations;
    }

    public String getName() {
        return this.name;
    }

    public InstanceComparisonDiffEntryExamples getExamples() {
        return this.examples;
    }

    public T getLocalValue() {
        return this.localValue;
    }

    public T getRemoteValue() {
        return this.remoteValue;
    }

    @JsonGetter(value="onlyImprovement")
    public abstract boolean isOnlyImprovement();

    public boolean isWithinAcceptedDeviations() {
        return this.withinAcceptedDeviations;
    }

    public EInstanceComparisonSummary getSummary() {
        if (this.isOnlyImprovement()) {
            return EInstanceComparisonSummary.ONLY_IMPROVEMENTS;
        }
        if (this.isWithinAcceptedDeviations()) {
            return EInstanceComparisonSummary.WITHIN_ACCEPTED_DEVIATION;
        }
        return EInstanceComparisonSummary.HAS_DIFFERENCES;
    }
}

