/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.profiler;

import com.teamscale.index.admin.profiler.ProfilerConfiguration;
import java.util.List;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

@Index(name="profiler-configurations", options={EStorageOption.COMPRESSED, EStorageOption.BACKUP})
public class ProfilerConfigurationIndex
implements IGlobalIndex {
    public static final String INDEX_NAME = "profiler-configurations";
    private final ValueIndex<ProfilerConfiguration> delegateIndex;

    public ProfilerConfigurationIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public List<ProfilerConfiguration> getAllProfilerConfigurations() throws StorageException {
        return this.delegateIndex.getAllEntries().extractSecondList();
    }

    public @Nullable ProfilerConfiguration getProfilerConfiguration(String configurationId) throws StorageException {
        if (StringUtils.isEmpty((String)configurationId)) {
            return null;
        }
        return (ProfilerConfiguration)this.delegateIndex.getValue(configurationId);
    }

    public void storeProfilerConfiguration(ProfilerConfiguration profilerConfiguration) throws StorageException {
        this.delegateIndex.setValue(profilerConfiguration.configurationId(), (Object)profilerConfiguration);
    }

    public void removeProfilerConfiguration(String configurationId) throws StorageException {
        this.delegateIndex.removeValue(configurationId);
    }
}

