/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture;

import com.teamscale.index.architecture.ArchitectureEditorComponentInfo;
import com.teamscale.index.architecture.ArchitectureInfo;
import com.teamscale.index.architecture.ArchitecturePolicyInfo;
import com.teamscale.index.architecture.ArchitectureXMLWriter;
import com.teamscale.index.architecture.TypeDependencyInfo;
import com.teamscale.index.architecture.assessment.shared.CodeMapping;
import com.teamscale.index.architecture.assessment.shared.TypeDependency;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.ArchitectureCreationModificationInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ArchitectureEditorUtils {
    public static String architectureDefinitionToXML(ArchitectureDefinition architecture, PublicProjectId projectId) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ArchitectureXMLWriter writer = new ArchitectureXMLWriter(stream, architecture, projectId);
        writer.writeArchitecture();
        writer.close();
        return stream.toString(StandardCharsets.UTF_8);
    }

    public static ArchitectureDefinition deserializeArchitectureDefinition(String architectureInfoJson) throws ConQATException {
        ArchitectureInfo architectureData = (ArchitectureInfo)JsonUtils.deserializeFromJsonWithNullCheck((String)architectureInfoJson, ArchitectureInfo.class);
        return ArchitectureEditorUtils.writeArchitectureDefinition(architectureData);
    }

    public static ArchitectureDefinition writeArchitectureDefinition(ArchitectureInfo data) throws ConQATException {
        ArchitectureDefinition architecture = new ArchitectureDefinition(data.getName(), data.isFileBased(), data.getFindingCreation(), data.getScopeIncludePattern(), data.getScopeExcludePattern(), new ArchitectureCreationModificationInfo(data.getCreatedBy(), data.getCreationDate(), data.getLastModifiedBy(), data.getModificationDate()), data.isLegacyCodeMapping(), data.isStructureOnly());
        architecture.addConstraints(data.getConstraints());
        for (ArchitectureEditorComponentInfo componentData : data.getComponents()) {
            architecture.addSubComponent(ArchitectureEditorUtils.createComponent(componentData));
        }
        for (ArchitecturePolicyInfo policyData : data.getPolicies()) {
            ComponentNode from = architecture.getComponentByName(policyData.getSource());
            ComponentNode to = architecture.getComponentByName(policyData.getTarget());
            DependencyPolicy policy = new DependencyPolicy(from, to, policyData.getPolicyType(), policyData.getPoints());
            for (TypeDependencyInfo toleratedDependency : policyData.getToleratedDependencies()) {
                policy.addToleratedTypeDependency(new TypeDependency(toleratedDependency.getFrom(), toleratedDependency.getTo()));
            }
            policy.registerWithComponents();
        }
        return architecture;
    }

    public static ComponentNode createComponent(ArchitectureEditorComponentInfo data) {
        ComponentNode component = new ComponentNode(data.getName(), data.getPosition(), data.getDimension(), data.getStereotype());
        component.setDescription(data.getComment());
        component.setSpecItemMapping(data.getSpecItemMapping());
        block5: for (CodeMapping mappingData : data.getCodeMappings()) {
            switch (mappingData.getType()) {
                case INCLUDE: {
                    component.addIncludePattern(mappingData.getPattern());
                    continue block5;
                }
                case EXCLUDE: {
                    component.addExcludePattern(mappingData.getPattern());
                    continue block5;
                }
                case EXCLUDE_COMPONENT: {
                    component.addExcludedComponent(mappingData.getPattern());
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown code mapping type: " + String.valueOf((Object)mappingData.getType()));
        }
        for (ArchitectureEditorComponentInfo subComponent : data.getSubComponents()) {
            component.addSubComponent(ArchitectureEditorUtils.createComponent(subComponent));
        }
        return component;
    }

    private ArchitectureEditorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

