/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.external;

import com.teamscale.index.architecture.external.ArchitectureUploadInfo;
import com.teamscale.index.external.ExternalUploadIndexBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;

@Index(name="external-architecture-uploads", options={EStorageOption.BRANCHED, EStorageOption.BACKUP, EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK}, valueClasses={ArchitectureUploadInfo.class})
public class ExternalArchitectureUploadIndex
extends ExternalUploadIndexBase<ArchitectureUploadInfo> {
    public static final String INDEX_NAME = "external-architecture-uploads";
    private static final String ARCHITECTURES_PATH_KEY = "#-#architectures#-#";

    public ExternalArchitectureUploadIndex(IStore store) {
        super(store);
    }

    @Override
    public void setCommitInfo(ArchitectureUploadInfo architectureUploadInfo) throws StorageException {
        super.setCommitInfo(architectureUploadInfo);
        HashSet<String> newExistingArchitectures = new HashSet<String>(this.getAllArchitecturePaths());
        newExistingArchitectures.addAll(architectureUploadInfo.getUniformPaths());
        CollectionUtils.removeAll(newExistingArchitectures, architectureUploadInfo.getDeletedArchitectures());
        this.store.putWithString(ARCHITECTURES_PATH_KEY, StorageUtils.serialize(new ArrayList<String>(newExistingArchitectures)));
    }

    public List<String> getAllArchitecturePaths() throws StorageException {
        ArrayList paths = StorageUtils.deserializeStringList((byte[])this.store.getWithString(ARCHITECTURES_PATH_KEY));
        return CollectionUtils.emptyIfNull((List)paths);
    }
}

