/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.read;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.StorageMigrator;
import com.teamscale.index.backup.BackupUtils;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.EBackupZipFileVersion;
import com.teamscale.index.backup.MigratedZipFile;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.EncryptionAwareStoreImporter;
import com.teamscale.index.backup.read.UserAndGroupHandler;
import com.teamscale.index.configuration.AnalysisProfileMigrationUtils;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.ExternalAnalysisGroup;
import com.teamscale.index.configuration.ExternalFindingsDescription;
import com.teamscale.index.configuration.MetricThresholdConfigurationUtils;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.index.dashboard.DashboardDescriptor;
import com.teamscale.index.dashboard.DashboardIndex;
import com.teamscale.index.dashboard.DashboardUtils;
import com.teamscale.index.dashboard.ProjectDashboardsMappingIndex;
import com.teamscale.index.migration.MigrationVersion144ABAPLintConfigFileUtils;
import com.teamscale.index.project.ExternalCodeMetricsDescriptionIndex;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.project.ExternalMetricsDescriptionIndexBase;
import com.teamscale.index.project.ExternalNonCodeMetricsDescriptionIndex;
import com.teamscale.index.project.MetricSchemaChangeEntry;
import eu.cqse.check.framework.core.EFindingEnablement;
import jakarta.ws.rs.InternalServerErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.transaction.TransactionHandler;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class GlobalStoreImporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final PublicProjectId GLOBAL_DATA_PROJECT_ID = new PublicProjectId("Global Data");
    private final ICancelable cancelable;
    private final TransactionHandler transactionHandler;
    private final IndexLayer transactionalMigrationIndexLayer;
    private final MigratedZipFile backupFile;
    private final EncryptionAwareStoreImporter storeImporter;
    private final EBackupZipFileVersion zipFileVersion;
    private final IndexLayer currentIndexLayer;
    private final StorageMigrator storageMigrator;

    public GlobalStoreImporter(ICancelable cancelable, TransactionHandler transactionHandler, IndexLayer transactionalMigrationIndexLayer, MigratedZipFile backupFile, EncryptionAwareStoreImporter storeImporter, EBackupZipFileVersion zipFileVersion, IndexLayer currentIndexLayer, StorageMigrator storageMigrator) {
        this.cancelable = cancelable;
        this.transactionHandler = transactionHandler;
        this.transactionalMigrationIndexLayer = transactionalMigrationIndexLayer;
        this.backupFile = backupFile;
        this.storeImporter = storeImporter;
        this.zipFileVersion = zipFileVersion;
        this.currentIndexLayer = currentIndexLayer;
        this.storageMigrator = storageMigrator;
    }

    public void handleGlobalData(BackupImportStatus backupImportStatus) throws MigrationException, ConQATException, IOException, ExecutionCanceledException {
        backupImportStatus.getOrCreateProjectStatus(GLOBAL_DATA_PROJECT_ID);
        UserAndGroupHandler userAndGroupImporter = new UserAndGroupHandler(this.currentIndexLayer, this.transactionalMigrationIndexLayer, this.containsStore("users"));
        userAndGroupImporter.preImport();
        if (!this.importGlobalData(backupImportStatus)) {
            this.transactionHandler.rollback();
            this.cancelable.verifyNotCanceled();
            return;
        }
        this.updateDashboardProjectMappings();
        userAndGroupImporter.postImport();
    }

    private void updateDashboardProjectMappings() {
        UUID currentDashboard = null;
        try {
            GlobalStorageSystem globalStorageSystem = this.transactionalMigrationIndexLayer.openGlobalStorageSystem();
            DashboardIndex dashboardIndex = (DashboardIndex)globalStorageSystem.openGlobalIndex(DashboardIndex.class);
            SetMap dashboardWithProjects = new SetMap();
            ProjectDashboardsMappingIndex projectDashboardsMappingIndex = (ProjectDashboardsMappingIndex)globalStorageSystem.openGlobalIndex(ProjectDashboardsMappingIndex.class);
            for (DashboardDescriptor dashboard : dashboardIndex.getAllDashboards()) {
                currentDashboard = dashboard.getId();
                Set<PublicProjectId> projectsInDashboard = DashboardUtils.extractProjectIdsFromDashboard(dashboard.getDescriptor());
                dashboardWithProjects.addAll((Object)dashboard.getId(), projectsInDashboard);
            }
            projectDashboardsMappingIndex.addProjectDashboardMappings((SetMap<UUID, PublicProjectId>)dashboardWithProjects);
        }
        catch (StorageException e) {
            LOGGER.error("Error updating mappings of dashboard {}. Project(s) of this dashboard may be incomplete.", currentDashboard, (Object)e);
        }
    }

    private boolean importGlobalData(BackupImportStatus backupImportStatus) throws IOException, ConQATException, MigrationException {
        BackupImportStatus.ImportProgress progress = backupImportStatus.getOrCreateProjectStatus(GLOBAL_DATA_PROJECT_ID);
        try {
            progress.setStatusMessage("Importing custom findings and metrics");
            this.cancelable.verifyNotCanceled();
            this.importCustomFindingsAndMetrics();
            progress.setStatusMessage("Importing analysis profiles");
            this.cancelable.verifyNotCanceled();
            Set<String> analysisProfilesInBackup = this.getAnalysisProfileNamesInBackup();
            this.importGlobalBackupData(this.storageMigrator, progress, analysisProfilesInBackup);
            this.importAnalysisProfiles(progress);
            progress.setStatusMessage("Importing threshold configurations");
            this.cancelable.verifyNotCanceled();
            this.importThresholdConfigurations();
            if (progress.getStatus() == EBackupStatus.FAILURE) {
                progress.setStatusMessage("Import failed");
                return false;
            }
            this.storageMigrator.flushBatchMigrationsForOpenStorageSystems();
            progress.setStatusMessage("Import completed");
            progress.setStatus(EBackupStatus.SUCCESS);
            return true;
        }
        catch (ExecutionCanceledException e) {
            progress.setStatusMessage(e.getMessage());
            progress.setStatus(EBackupStatus.FAILURE);
            return false;
        }
    }

    private void importGlobalBackupData(StorageMigrator storageMigrator, BackupImportStatus.ImportProgress progress, Set<String> analysisProfileNamesInBackup) throws IOException, ExecutionCanceledException, StorageException {
        SchemaAwareStorageSystem globalStorageSystem = storageMigrator.decorate(this.transactionalMigrationIndexLayer).openGlobalStorageSystem();
        for (ZipArchiveEntry entry : this.backupFile.getEntries()) {
            this.cancelable.verifyNotCanceled();
            String storeName = entry.getName();
            if (!BackupUtils.isStoreFile(storeName)) continue;
            progress.setStatusMessage("Importing " + storeName);
            try {
                this.importGlobalStore(entry, storeName, storageMigrator, globalStorageSystem, analysisProfileNamesInBackup);
            }
            catch (MigrationException | IOException | ConQATException e) {
                throw new IOException("Error importing global store '" + storeName + "'", e);
            }
        }
    }

    private void importGlobalStore(ZipArchiveEntry entry, String storeName, StorageMigrator storageMigrator, SchemaAwareStorageSystem globalStorageSystem, Set<String> analysisProfileNamesInBackup) throws ConQATException, IOException, ExecutionCanceledException, MigrationException {
        if (!storageMigrator.shouldImportStore(storeName)) {
            return;
        }
        if ("analysis-profiles".equals(storeName)) {
            return;
        }
        if (!globalStorageSystem.hasIndex(storeName)) {
            throw new InternalServerErrorException("Store '" + storeName + "' from backup not configured. In case of a global store: Is it on the class path, for example, in the package `com.teamscale.index`?");
        }
        IStore store = globalStorageSystem.openStore(storeName);
        if ("analysis-profile-versions".equals(storeName)) {
            store = GlobalStoreImporter.createStoreDecoratorFilteringNonImportedAnalysisProfiles(analysisProfileNamesInBackup, store);
        }
        this.storeImporter.importStore(entry, store, this.cancelable);
    }

    private void importCustomFindingsAndMetrics() throws ConQATException {
        try {
            GlobalStorageSystem globalStorageSystem = this.transactionalMigrationIndexLayer.openGlobalStorageSystem();
            ExternalCodeMetricsDescriptionIndex externalCodeMetricsIndex = (ExternalCodeMetricsDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalCodeMetricsDescriptionIndex.class);
            ExternalNonCodeMetricsDescriptionIndex externalNonCodeMetricsIndex = (ExternalNonCodeMetricsDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalNonCodeMetricsDescriptionIndex.class);
            ExternalFindingsGroupDescriptionIndex externalFindingsIndex = (ExternalFindingsGroupDescriptionIndex)globalStorageSystem.openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
            block10: for (ZipArchiveEntry entry : this.backupFile.getEntries()) {
                switch (entry.getName()) {
                    case "custom-external-metrics/metric-entries.json": {
                        this.importExternalMetrics(externalCodeMetricsIndex, entry);
                        continue block10;
                    }
                    case "custom-external-metrics/non-code-metric-entries.json": {
                        this.importExternalMetrics(externalNonCodeMetricsIndex, entry);
                        continue block10;
                    }
                }
                this.importFindingsForAnalysisTools(externalFindingsIndex, entry);
            }
        }
        catch (IOException e) {
            throw new ConQATException("Invalid backup ZIP format: " + e.getMessage(), (Throwable)e);
        }
    }

    private void importExternalMetrics(ExternalMetricsDescriptionIndexBase externalMetricsIndex, ZipArchiveEntry zis) throws ConQATException, IOException {
        try (InputStream stream = this.backupFile.getInputStream(zis);){
            List<MetricSchemaChangeEntry> metrics = Arrays.asList(this.deserializeFromJson(stream, MetricSchemaChangeEntry[].class));
            externalMetricsIndex.putMetrics(metrics);
        }
    }

    private Set<String> getAnalysisProfileNamesInBackup() throws ExecutionCanceledException, IOException, MigrationException {
        HashSet<String> analysisProfileNames = new HashSet<String>();
        for (ZipArchiveEntry entry : this.backupFile.getEntries()) {
            String storeName = entry.getName();
            if (!storeName.startsWith("__analysis_profiles/") || entry.isDirectory() || FileSystemUtils.isSystemFileName((String)storeName)) continue;
            InputStream stream = this.backupFile.getInputStream(entry);
            try {
                byte[] data = FileSystemUtils.readStreamBinary((InputStream)stream);
                String json = StringUtils.bytesToString((byte[])data);
                String analysisProfileName = AnalysisProfileMigrationUtils.getAnalysisProfileName(json);
                analysisProfileNames.add(analysisProfileName);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return analysisProfileNames;
    }

    private void importAnalysisProfiles(BackupImportStatus.ImportProgress progress) throws StorageException, IOException, MigrationException, ExecutionCanceledException {
        GlobalStorageSystem globalStorageSystem = this.transactionalMigrationIndexLayer.openGlobalStorageSystem();
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = (AnalysisProfileVersionedIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        this.importXmlConfigurationEntries("__analysis_profiles/", (data, fileName) -> GlobalStoreImporter.importAnalysisProfile(globalStorageSystem, progress, analysisProfileVersionedIndex, fileName, data));
    }

    private <T> List<T> importXmlConfigurationEntries(String folderPrefix, BiFunctionWithException<String, byte[], T, MigrationException> storeEntryFunction) throws IOException, MigrationException, ExecutionCanceledException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ZipArchiveEntry entry : this.backupFile.getEntries()) {
            byte[] data;
            this.cancelable.verifyNotCanceled();
            String storeName = entry.getName();
            if (!storeName.startsWith(folderPrefix) || entry.isDirectory() || FileSystemUtils.isSystemFileName((String)storeName)) continue;
            try (InputStream stream = this.backupFile.getInputStream(entry);){
                data = FileSystemUtils.readStreamBinary((InputStream)stream);
            }
            String fileName = StringUtils.stripPrefix((String)storeName, (String)folderPrefix);
            try {
                Object storeEntry = storeEntryFunction.apply((Object)fileName, (Object)data);
                if (storeEntry == null) continue;
                result.add(storeEntry);
            }
            catch (MigrationException e) {
                throw new MigrationException("Error importing configuration '" + fileName + "': " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private void importThresholdConfigurations() throws StorageException, IOException, MigrationException, ExecutionCanceledException {
        HashMap<String, ObjectNode> thresholdConfigDataByName = new HashMap<String, ObjectNode>();
        this.importXmlConfigurationEntries("__threshold_configurations/", (notNeeded, data) -> {
            try {
                ObjectNode thresholdConfig = (ObjectNode)JsonUtils.deserializeFromJson((String)StringUtils.bytesToString((byte[])data), ObjectNode.class);
                String name = thresholdConfig.get("name").asText();
                thresholdConfigDataByName.put(name, thresholdConfig);
            }
            catch (JsonSerializationException e) {
                throw new MigrationException("Configuration is invalid: " + e.getMessage(), (Throwable)e);
            }
            return null;
        });
        GlobalStorageSystem globalStorageSystem = this.transactionalMigrationIndexLayer.openGlobalStorageSystem();
        MetricThresholdConfigurationIndex metricThresholdConfigurationIndex = (MetricThresholdConfigurationIndex)globalStorageSystem.openGlobalIndex(MetricThresholdConfigurationIndex.class);
        for (ObjectNode thresholdConfig : thresholdConfigDataByName.values()) {
            try {
                GlobalStoreImporter.storeThresholdConfiguration(metricThresholdConfigurationIndex, thresholdConfig, globalStorageSystem, thresholdConfigDataByName);
            }
            catch (MetricThresholdConfigurationException e) {
                throw new MigrationException("Configuration is invalid: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static @NonNull IStore createStoreDecoratorFilteringNonImportedAnalysisProfiles(final Set<String> analysisProfileNamesInBackup, IStore store) {
        store = new DelegatingStore((IStore)store){

            public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
                super.put((PairList)keysValues.stream().filter(pair -> analysisProfileNamesInBackup.contains(StringUtils.bytesToString((byte[])((byte[])pair.getFirst())))).collect(PairList.toPairList()));
            }

            public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
                if (analysisProfileNamesInBackup.contains(StringUtils.bytesToString((byte[])key))) {
                    super.put(key, value);
                }
            }
        };
        return store;
    }

    private void importFindingsForAnalysisTools(ExternalFindingsGroupDescriptionIndex index, ZipArchiveEntry entry) throws IOException, ConQATException {
        for (EAnalysisTool analysisTool : EAnalysisTool.CUSTOM_FINDINGS_TOOLS) {
            InputStream stream;
            String entryName = entry.getName();
            boolean isDescription = entryName.equals(BackupUtils.getExternalFindingDescriptionsPath(analysisTool));
            boolean isGroup = entryName.equals(BackupUtils.getExternalFindingGroupsPath(analysisTool));
            if (isDescription) {
                stream = this.backupFile.getInputStream(entry);
                try {
                    this.importFindingDescriptions(index, analysisTool, stream);
                    continue;
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                    continue;
                }
            }
            if (!isGroup) continue;
            stream = this.backupFile.getInputStream(entry);
            try {
                List<ExternalAnalysisGroup> groups = Arrays.asList(this.deserializeFromJson(stream, ExternalAnalysisGroup[].class));
                index.storeGroups(groups, analysisTool);
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
    }

    private void importFindingDescriptions(ExternalFindingsGroupDescriptionIndex index, EAnalysisTool analysisTool, InputStream stream) throws JsonSerializationException, IOException, StorageException {
        List<ExternalFindingsDescription> descriptions = Arrays.asList(this.deserializeFromJson(stream, ExternalFindingsDescription[].class));
        if (this.zipFileVersion.ordinal() < EBackupZipFileVersion.FILE_VERSION_V4.ordinal()) {
            for (ExternalFindingsDescription description : descriptions) {
                if (analysisTool != EAnalysisTool.ROSLYN) continue;
                description.setEnablement(EFindingEnablement.AUTO);
            }
        }
        index.storeDescriptions(descriptions, analysisTool);
    }

    private static @Nullable AnalysisProfile importAnalysisProfile(GlobalStorageSystem globalStorageSystem, BackupImportStatus.ImportProgress progress, AnalysisProfileVersionedIndex analysisProfileVersionedIndex, byte[] data, String fileName) throws MigrationException {
        try {
            AnalysisProfile analysisProfile = AnalysisProfileUtils.deserializeAnalysisProfile(data, globalStorageSystem);
            if (analysisProfile == null) {
                return null;
            }
            AnalysisProfileUtils.addNewAnalysisProfileVersion(analysisProfileVersionedIndex, (AnalysisProfileIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileIndex.class), analysisProfile, "[System]", "Analysis Profile imported", globalStorageSystem);
            GlobalStoreImporter.determineAndLogUsageOfDeprecatedAbapLintConfigFileOption(data, progress, analysisProfile.getName());
            GlobalStoreImporter.determineAndLogUnconfiguredChecks(globalStorageSystem, progress, analysisProfile);
            GlobalStoreImporter.validateAnalysisProfile(globalStorageSystem, progress, analysisProfile);
            return analysisProfile;
        }
        catch (ProjectConfigurationException | StorageException e) {
            progress.error("Error importing analysis profile '" + fileName + "': " + e.getMessage());
            return null;
        }
    }

    private static void validateAnalysisProfile(GlobalStorageSystem globalStorageSystem, BackupImportStatus.ImportProgress progress, AnalysisProfile analysisProfile) {
        try {
            ProjectValidationUtils.validateAnalysisProfile(analysisProfile, globalStorageSystem, true);
        }
        catch (StorageException e) {
            progress.error("Imported analysis profile has validation errors: " + e.getMessage());
        }
    }

    private static void determineAndLogUsageOfDeprecatedAbapLintConfigFileOption(byte[] data, BackupImportStatus.ImportProgress progress, String analysisProfileName) {
        try {
            ObjectNode profile = (ObjectNode)JsonUtils.deserializeFromJson((String)StringUtils.bytesToString((byte[])data), ObjectNode.class);
            ObjectNode options = (ObjectNode)profile.get("options");
            if (options != null && options.has("ABAPLint config file") && !options.get("ABAPLint config file").asText().isEmpty()) {
                progress.warn(MigrationVersion144ABAPLintConfigFileUtils.getWarningMessage(analysisProfileName));
            }
        }
        catch (JsonSerializationException jsonSerializationException) {
            // empty catch block
        }
    }

    private static void determineAndLogUnconfiguredChecks(GlobalStorageSystem globalStorageSystem, BackupImportStatus.ImportProgress progress, AnalysisProfile analysisProfile) throws ProjectConfigurationException {
        ConfigurationTemplate template = ConfigRegistry.getInstance().createConfigurationTemplate((Set)analysisProfile.getLanguages(), (Set)analysisProfile.getTools(), globalStorageSystem);
        AnalysisProfileUtils.synchronizeAnalysisGroups(template, analysisProfile, globalStorageSystem);
        for (AnalysisGroupDescriptor analysisGroupDescriptor : template.getAnalysisGroups()) {
            for (Pair check : analysisGroupDescriptor.getUnconfiguredChecks()) {
                progress.logUnconfiguredCheck(analysisProfile.getName(), (String)check.getSecond(), analysisGroupDescriptor.getName());
            }
        }
    }

    private static void storeThresholdConfiguration(MetricThresholdConfigurationIndex metricThresholdConfigurationIndex, ObjectNode data, GlobalStorageSystem globalStorageSystem, Map<String, ObjectNode> jsonDataByThresholdConfigName) throws MigrationException, StorageException, MetricThresholdConfigurationException {
        MetricThresholdConfiguration thresholdConfiguration = MetricThresholdConfigurationUtils.createMetricThresholdConfiguration(data, metricThresholdConfigurationIndex, null, false, globalStorageSystem, jsonDataByThresholdConfigName);
        MetricThresholdConfigurationUtils.validateMetricThresholdConfiguration(thresholdConfiguration, globalStorageSystem);
    }

    private <T> T deserializeFromJson(InputStream stream, Class<T> expectedClass) throws JsonSerializationException, IOException {
        List<Charset> charsetCandidates = this.getCharsetCandidates();
        String json = charsetCandidates.size() == 1 ? FileSystemUtils.readStream((InputStream)stream, (Charset)charsetCandidates.getFirst()) : GlobalStoreImporter.tryReadJsonWithDifferentCharsets(stream, charsetCandidates);
        return (T)JsonUtils.deserializeFromJson((String)json, expectedClass);
    }

    private List<Charset> getCharsetCandidates() {
        if (this.zipFileVersion.compareTo(EBackupZipFileVersion.FILE_VERSION_V3) >= 0) {
            return List.of(StandardCharsets.UTF_8);
        }
        if (Runtime.version().feature() < 18) {
            return List.of(Charset.defaultCharset());
        }
        if (FileSystemUtils.SYSTEM_CHARSET.equals(Charset.defaultCharset())) {
            return List.of(FileSystemUtils.SYSTEM_CHARSET);
        }
        Optional useSystemCharset = TeamscaleSystemProperties.BACKUP_IMPORT_USE_SYSTEM_CHARSET.getValue();
        if (useSystemCharset.isEmpty()) {
            return List.of(Charset.defaultCharset(), FileSystemUtils.SYSTEM_CHARSET);
        }
        if (((Boolean)useSystemCharset.get()).booleanValue()) {
            return List.of(FileSystemUtils.SYSTEM_CHARSET);
        }
        return List.of(Charset.defaultCharset());
    }

    private static @NonNull String tryReadJsonWithDifferentCharsets(InputStream stream, List<Charset> charsetCandidates) throws IOException {
        CCSMAssert.isFalse((boolean)charsetCandidates.isEmpty(), (String)"Expected charset candidates to not be empty");
        byte[] bytes = stream.readAllBytes();
        String json = null;
        for (Charset charsetCandidate : charsetCandidates) {
            String jsonForCharset = new String(bytes, charsetCandidate);
            if (json != null && !json.equals(jsonForCharset)) {
                throw new IOException("It seems like you are importing an old backup (prior to Teamscale v9.6), which still\nuses the default charset for some contents.\nThe default charset is either configured via the system property\n\"-Dfile.encoding=XXX\" or the system charset.\nWith Java 18, the default charset was changed to use UTF-8 and not fall back to the system\ncharset, if not explicitly configured.\nUnfortunately, there is now no way for Teamscale to detect, which charset to\nuse during backup import.\nFor this, please set the \"%s\" property to either \"true\" if you did NOT\nspecify a \"file.encoding\" (i.e., Teamscale should use the system charset), or \"false\" if you specified a \"file.encoding\" (and Teamscale should use\nthat).\n".formatted(TeamscaleSystemProperties.BACKUP_IMPORT_USE_SYSTEM_CHARSET.getName()));
            }
            json = jsonForCharset;
        }
        return json;
    }

    private boolean containsStore(String storeName) {
        for (ZipArchiveEntry entry : this.backupFile.getEntries()) {
            if (!storeName.equals(entry.getName())) continue;
            return true;
        }
        return false;
    }
}

