/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.binary_size.common_substrings;

import com.teamscale.index.binary_size.common_substrings.StringLiteralSequence;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public class StringLiteralSequenceExtractor {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<String> KNOWN_STRING_LITERAL_PREFIXES = List.of("\"", "R\"", "L\"", "LR\"", "u8\"", "u8R\"", "u\"", "uR\"", "U\"", "UR\"", "@\"");

    public static List<StringLiteralSequence> collectStringLiteralSequencesFromTokenElement(TokenElementInfo tokenElementInfo) {
        ArrayList<StringLiteralSequence> literals = new ArrayList<StringLiteralSequence>();
        LineAndOffsetTransformers lineAndOffsetTransformers = new LineAndOffsetTransformers(tokenElementInfo);
        List<IToken> tokens = tokenElementInfo.getPreprocessedTokens();
        int tokenIndex = -1;
        while ((tokenIndex = StringLiteralSequenceExtractor.findNextStringLiteral(tokens, tokenIndex + 1)) != -1) {
            ArrayList<IToken> consecutiveStringLiterals = new ArrayList<IToken>();
            while (tokenIndex < tokens.size()) {
                ETokenType tokenType = tokens.get(tokenIndex).getType();
                if (tokenType.getTokenClass() == ETokenType.ETokenClass.COMMENT) {
                    ++tokenIndex;
                    continue;
                }
                if (tokenType != ETokenType.STRING_LITERAL) break;
                consecutiveStringLiterals.add(tokens.get(tokenIndex));
                ++tokenIndex;
            }
            StringLiteralSequence combinedStringLiteral = StringLiteralSequenceExtractor.computeCombinedStringLiteral(tokenElementInfo, consecutiveStringLiterals, lineAndOffsetTransformers);
            literals.add(combinedStringLiteral);
        }
        return literals;
    }

    private static int findNextStringLiteral(List<IToken> tokens, int startIndex) {
        for (int tokenIndex = startIndex; tokenIndex < tokens.size(); ++tokenIndex) {
            int closingIndex;
            if (TokenStreamTextUtils.hasSequence(tokens, (int)tokenIndex, (String[])new String[]{"static_assert", "("}) && (closingIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(tokenIndex + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) != -1) {
                tokenIndex = closingIndex;
                continue;
            }
            if (tokens.get(tokenIndex).getType() != ETokenType.STRING_LITERAL) continue;
            return tokenIndex;
        }
        return -1;
    }

    private static StringLiteralSequence computeCombinedStringLiteral(TokenElementInfo tokenElementInfo, List<IToken> consecutiveStringLiterals, LineAndOffsetTransformers lineAndOffsetTransformers) {
        StringBuilder combinedLiteralText = new StringBuilder();
        ArrayList<StringLiteralSequence.StringLiteralPositioningInfo> stringConcatenationOffsets = new ArrayList<StringLiteralSequence.StringLiteralPositioningInfo>();
        for (IToken currentToken : consecutiveStringLiterals) {
            StringLiteralSequence.StringLiteralPositioningInfo literalPositioningInfo = StringLiteralSequenceExtractor.buildPositioningInfoForToken(currentToken, combinedLiteralText, lineAndOffsetTransformers, tokenElementInfo);
            if (literalPositioningInfo == null) {
                LOGGER.warn("Could not determine string prefix length for literal: {} in {}:{}. Ignoring this literal.", (Object)currentToken.getText(), (Object)tokenElementInfo.getText(), (Object)currentToken.getLineNumber());
                continue;
            }
            stringConcatenationOffsets.add(literalPositioningInfo);
        }
        StringLiteralSequenceExtractor.collapsePositioningInfosFromSameMacroExpansion(stringConcatenationOffsets);
        return new StringLiteralSequence(combinedLiteralText.toString(), tokenElementInfo.getUniformPath(), stringConcatenationOffsets.toArray(new StringLiteralSequence.StringLiteralPositioningInfo[0]));
    }

    private static void collapsePositioningInfosFromSameMacroExpansion(List<StringLiteralSequence.StringLiteralPositioningInfo> positioningInfos) {
        for (int i = 1; i < positioningInfos.size(); ++i) {
            StringLiteralSequence.StringLiteralPositioningInfo previous = positioningInfos.get(i - 1);
            StringLiteralSequence.StringLiteralPositioningInfo current = positioningInfos.get(i);
            if (!previous.isMacroGenerated() || !current.isMacroGenerated() || previous.startOffsetInFile() != current.startOffsetInFile()) continue;
            StringLiteralSequence.StringLiteralPositioningInfo newPrevious = new StringLiteralSequence.StringLiteralPositioningInfo(previous.charOffsetInLiteral(), previous.startOffsetInFile(), previous.endOffsetInFile(), previous.literalPartTextLength() + current.literalPartTextLength(), true, previous.line());
            positioningInfos.set(i - 1, newPrevious);
            positioningInfos.remove(i);
            --i;
        }
    }

    private static @Nullable StringLiteralSequence.StringLiteralPositioningInfo buildPositioningInfoForToken(IToken currentToken, StringBuilder combinedLiteralText, LineAndOffsetTransformers lineAndOffsetTransformers, TokenElementInfo tokenElementInfo) {
        int literalTokenPrefixLength = StringLiteralSequenceExtractor.determineStringLiteralPrefixLength(currentToken);
        if (literalTokenPrefixLength == -1) {
            return null;
        }
        int offsetInLiteral = combinedLiteralText.length();
        String literalPartText = currentToken.getText().substring(literalTokenPrefixLength);
        literalPartText = StringUtils.stripSuffix((String)literalPartText, (String)"\"");
        combinedLiteralText.append(literalPartText);
        lineAndOffsetTransformers.lazyInitializeConverters();
        int unfilteredStartOffset = lineAndOffsetTransformers.offsetTransformer.getUnfilteredOffset(currentToken.getOffset());
        int line = lineAndOffsetTransformers.unfilteredLineOffsetConverter.getLine(unfilteredStartOffset);
        if (TokenUtils.isMacroGenerated((IToken)currentToken)) {
            UnmodifiableList<IToken> tokensBeforePreprocessing = tokenElementInfo.getTokens();
            IToken macroNameToken = (IToken)tokensBeforePreprocessing.get(TokenStreamUtils.indexOfByOffset(tokensBeforePreprocessing, (int)currentToken.getOffset()));
            int unfilteredEndOffset = lineAndOffsetTransformers.offsetTransformer.getUnfilteredOffset(macroNameToken.getEndOffset());
            return new StringLiteralSequence.StringLiteralPositioningInfo(offsetInLiteral, unfilteredStartOffset, unfilteredEndOffset, literalPartText.length(), true, line);
        }
        int unfilteredEndOffset = lineAndOffsetTransformers.offsetTransformer.getUnfilteredOffset(currentToken.getEndOffset());
        return new StringLiteralSequence.StringLiteralPositioningInfo(offsetInLiteral, unfilteredStartOffset += literalTokenPrefixLength, --unfilteredEndOffset, literalPartText.length(), false, line);
    }

    private static int determineStringLiteralPrefixLength(IToken currentToken) {
        String text = currentToken.getText();
        for (String prefix : KNOWN_STRING_LITERAL_PREFIXES) {
            if (!text.startsWith(prefix)) continue;
            return prefix.length();
        }
        return -1;
    }

    public static TextRegionLocation buildLocationForOffsetsInLiteral(StringLiteralSequence originLiteral, int startOffsetFromLiteralBegin, int endOffsetFromLiteralBegin) {
        int startLine = 0;
        int endLine = 0;
        int startOffset = 0;
        int endOffsetEnd = 0;
        for (StringLiteralSequence.StringLiteralPositioningInfo positioningInfo : originLiteral.positioningInfos) {
            if (positioningInfo.containsOffsetFromLiteralBegin(startOffsetFromLiteralBegin)) {
                startLine = positioningInfo.line();
                startOffset = positioningInfo.isMacroGenerated() ? positioningInfo.startOffsetInFile() : positioningInfo.startOffsetInFile() + (startOffsetFromLiteralBegin - positioningInfo.charOffsetInLiteral());
            }
            if (!positioningInfo.containsOffsetFromLiteralBegin(endOffsetFromLiteralBegin)) continue;
            endLine = positioningInfo.line();
            if (positioningInfo.isMacroGenerated()) {
                endOffsetEnd = positioningInfo.endOffsetInFile();
                break;
            }
            endOffsetEnd = positioningInfo.startOffsetInFile() + (endOffsetFromLiteralBegin - positioningInfo.charOffsetInLiteral());
            break;
        }
        return new TextRegionLocation(originLiteral.uniformPath, startOffset, endOffsetEnd, startLine, endLine);
    }

    private static class LineAndOffsetTransformers {
        private final TokenElementInfo tokenElementInfo;
        private StringOffsetTransformer offsetTransformer = null;
        private LineOffsetConverter unfilteredLineOffsetConverter = null;

        private LineAndOffsetTransformers(TokenElementInfo tokenElementInfo) {
            this.tokenElementInfo = tokenElementInfo;
        }

        private void lazyInitializeConverters() {
            if (this.offsetTransformer == null) {
                this.offsetTransformer = new StringOffsetTransformer((List)this.tokenElementInfo.getFilterDeletions());
            }
            if (this.unfilteredLineOffsetConverter == null) {
                this.unfilteredLineOffsetConverter = new LineOffsetConverter(this.tokenElementInfo.getText());
            }
        }
    }
}

