/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.index.code_clones.align.CloneAstAligner;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.core.Unit;
import com.teamscale.index.code_clones.normalization.FastUnifiedNormalization;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NonNull;

class CloneClassAndUnitCountUpdater {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int minCloneLength;
    private final boolean allowGaps;
    private final boolean exclusiveIntraComponentDetection;
    private final Map<String, TokenElementInfo> uniformPathToElement;
    private Map<String, TokenElementInfo> otherElements = null;
    private Set<Map.Entry<String, TokenElementInfo>> wiaElements = null;
    private Collection<CloneClass> cloneClasses;
    private Collection<CloneClass> otherCloneClasses = null;
    private Set<CloneClass> wiaCloneClasses = null;
    private Map<String, Integer> uniformPathToUnitCount = null;

    CloneClassAndUnitCountUpdater(int minCloneLength, boolean allowGaps, boolean exclusiveIntraComponentDetection, Collection<CloneClass> cloneClasses, Map<String, TokenElementInfo> uniformPathToElement) {
        this.minCloneLength = minCloneLength;
        this.allowGaps = allowGaps;
        this.exclusiveIntraComponentDetection = exclusiveIntraComponentDetection;
        this.cloneClasses = cloneClasses;
        this.uniformPathToElement = uniformPathToElement;
    }

    public Collection<CloneClass> getCloneClasses() {
        return this.cloneClasses;
    }

    public Map<String, Integer> getUniformPathToUnitCount() {
        if (this.uniformPathToUnitCount == null) {
            return CollectionUtils.emptyMap();
        }
        return this.uniformPathToUnitCount;
    }

    public void computeCloneClassesAndUnitCounts() throws StorageException {
        if (!this.allowGaps) {
            this.doAstAlignmentIfNeeded();
        } else {
            this.computeUnitCounts(this.uniformPathToElement.values());
        }
    }

    private void doAstAlignmentIfNeeded() throws StorageException {
        this.initializeFields();
        if (this.hasOtherElements()) {
            CloneAstAligner.AstAlignmentResult astAlignmentResult = new CloneAstAligner(this.minCloneLength, this.exclusiveIntraComponentDetection).performAlignment(this.otherCloneClasses, this.otherElements);
            this.otherCloneClasses = astAlignmentResult.getCloneClasses();
            this.uniformPathToUnitCount = astAlignmentResult.getUniformPathToUnitCount();
        }
        if (this.hasWiaElements()) {
            this.computeUnitCounts(this.wiaElements.stream().map(Map.Entry::getValue).toList());
        }
        this.cloneClasses = CollectionUtils.unionSet(this.wiaCloneClasses, (Collection[])new Collection[]{this.otherCloneClasses});
    }

    private boolean hasOtherElements() {
        return !this.otherElements.isEmpty();
    }

    private boolean hasWiaElements() {
        return !this.wiaElements.isEmpty();
    }

    private void initializeFields() {
        this.wiaElements = this.uniformPathToElement.entrySet().stream().filter(element -> WiaUtils.isWiaEnabledLanguage((ELanguage)((TokenElementInfo)((Object)((Object)element.getValue()))).getLanguage())).collect(Collectors.toSet());
        if (!this.hasWiaElements()) {
            this.otherElements = this.uniformPathToElement;
            this.wiaCloneClasses = CollectionUtils.emptySet();
            this.otherCloneClasses = this.cloneClasses;
        } else {
            this.otherElements = CollectionUtils.differenceSet(this.uniformPathToElement.entrySet(), (Collection[])new Collection[]{this.wiaElements}).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Set wiaUniformPaths = this.wiaElements.stream().map(Map.Entry::getKey).collect(Collectors.toSet());
            this.wiaCloneClasses = this.cloneClasses.stream().filter(clazz -> clazz.getClones().stream().anyMatch(clone -> wiaUniformPaths.contains(clone.getUniformPath()))).collect(Collectors.toSet());
            this.otherCloneClasses = CollectionUtils.differenceSet(this.cloneClasses, (Collection[])new Collection[]{this.wiaCloneClasses});
            CCSMAssert.isTrue((this.uniformPathToElement.size() == this.wiaElements.size() + this.otherElements.size() ? 1 : 0) != 0, () -> "Element decomposition failed: %d != %d + %d".formatted(this.uniformPathToElement.size(), this.wiaElements.size(), this.otherElements.size()));
            this.verifyCloneClassDecomposition();
        }
    }

    private void verifyCloneClassDecomposition() {
        if (this.cloneClasses.size() != this.wiaCloneClasses.size() + this.otherCloneClasses.size()) {
            HashMap hashToCloneClass = new HashMap();
            this.cloneClasses.forEach(cloneClass -> hashToCloneClass.computeIfAbsent(cloneClass.hashCode(), key -> new ArrayList()).add(cloneClass));
            String detailsString = hashToCloneClass.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() != 1).map(entry -> "hash=%d count=%d cloneDetails=%s".formatted(entry.getKey(), ((List)entry.getValue()).size(), ((List)entry.getValue()).toString())).collect(Collectors.joining("\n"));
            LOGGER.error("Clone classes decomposition failed: {} != {} + {}\n{}", (Object)this.cloneClasses.size(), (Object)this.wiaCloneClasses.size(), (Object)this.otherCloneClasses.size(), (Object)detailsString);
        }
    }

    private void computeUnitCounts(@NonNull Collection<TokenElementInfo> elements) {
        if (this.uniformPathToUnitCount == null) {
            this.uniformPathToUnitCount = HashMap.newHashMap(elements.size());
        }
        for (TokenElementInfo element : elements) {
            List<Unit> units = FastUnifiedNormalization.getNormalizedUnits(element);
            this.uniformPathToUnitCount.put(element.getUniformPath(), units.size());
        }
    }
}

