/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.google.common.base.Verify;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.StepParameterObject;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.code_clones.CloneAnalysisUtils;
import com.teamscale.index.code_clones.CloneChunkByHashIndex;
import com.teamscale.index.code_clones.CloneChunkByPathIndex;
import com.teamscale.index.code_clones.CloneClassAndUnitCountUpdater;
import com.teamscale.index.code_clones.CloneComponentHelper;
import com.teamscale.index.code_clones.CloneDetectionResultSynchronizer;
import com.teamscale.index.code_clones.UnitAwareCloneClassFilter;
import com.teamscale.index.code_clones.constraint.ICloneClassConstraint;
import com.teamscale.index.code_clones.constraint.MinimalOverlappingConstraint;
import com.teamscale.index.code_clones.constraint.SimilarityConstraint;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.detection.CloneDetector;
import com.teamscale.index.code_clones.report.SizeFilteringCollectingCloneClassReporter;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.wia.WiaUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.util.tokens.WiaTokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class CloneSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CODE_CLONE_CLASS_SIZE_LIMIT_PARAMETER = "code-clone-class-size-limit";
    public static final String ALLOW_CODE_GAPS_PARAMETER = "allow-code-gaps";
    public static final String MIN_CODE_CLONE_LENGTH_PARAMETER = "min-code-clone-length";
    public static final String INCLUDE_CLOSED_SPEC_ITEMS = "include-closed-spec-items";
    public static final String SPEC_ITEM_CLONE_CLASS_SIZE_LIMIT_PARAMETER = "spec-item-clone-class-size-limit";
    public static final String ALLOW_SPEC_ITEM_GAPS_PARAMETER = "allow-spec-item-gaps";
    public static final String MIN_SPEC_ITEM_CLONE_LENGTH_PARAMETER = "min-spec-item-clone-length";
    @StepParameter(value="allow-code-gaps")
    private boolean allowCodeGaps = false;
    @StepParameter(value="code-clone-class-size-limit")
    private int codeCloneClassSizeLimit;
    @StepParameter(value="clone-detection-enablement", optional=true)
    private CodeScopeAware<Boolean> cloneDetectionEnablement = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CloneChunkByPathIndex byPathChunkIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CloneChunkByHashIndex byHashChunkIndex;
    @StepParameter(value="min-code-clone-length")
    private int codeCloneLength;
    @StepParameter(value="include-closed-spec-items")
    private boolean includeClosedSpecItems = false;
    @StepParameter(value="allow-spec-item-gaps")
    private boolean allowSpecItemGaps = false;
    @StepParameter(value="spec-item-clone-class-size-limit")
    private int specItemCloneClassSizeLimit;
    @StepParameter(value="min-spec-item-clone-length")
    private int specItemCloneLength;
    @DeltaSource(value=TokenElementIndex.class, indexName="content")
    private KeyDelta contentDelta;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="content")
    private TokenElementIndex contentIndex;
    @StepParameterObject
    private final CloneDetectionResultSynchronizer resultSynchronizer = new CloneDetectionResultSynchronizer();
    private @Nullable CloneComponentHelper componentHelper;
    @StepParameter(value="ignored-pattern", optional=true)
    private final List<String> ignoredUniformPathPatterns = new ArrayList<String>();
    private PatternList compiledIgnoredUniformPathPatterns;

    public void execute() throws Exception {
        this.resultSynchronizer.verifyCodeScopeConfiguration();
        this.compiledIgnoredUniformPathPatterns = CloneAnalysisUtils.compileUniformPathPatterns(this.ignoredUniformPathPatterns);
        if (!this.initComponentHelper()) {
            return;
        }
        List<String> changedPaths = this.determineChangedPaths();
        ArrayList<String> workItemPaths = new ArrayList<String>();
        ArrayList<String> codePaths = new ArrayList<String>();
        for (String path : changedPaths) {
            if (WiaUtils.isWorkItemPath((String)path)) {
                workItemPaths.add(path);
                continue;
            }
            codePaths.add(path);
        }
        this.executeForPaths(codePaths, this.codeCloneLength, this.allowCodeGaps, this.codeCloneClassSizeLimit);
        this.executeForPaths(workItemPaths, this.specItemCloneLength, this.allowSpecItemGaps, this.specItemCloneClassSizeLimit);
        this.resultSynchronizer.persistCloneClasses();
        this.resultSynchronizer.persistDeletions(this.filterPathsByPathOnly(this.contentDelta.getDeletedKeysAsStrings()));
    }

    private void executeForPaths(List<String> changedPaths, int minCloneLength, boolean allowGaps, int cloneClassSizeLimit) throws ExecutionException {
        if (changedPaths.isEmpty()) {
            return;
        }
        Set allOtherPathsAffectedByClones = Collections.synchronizedSet(new HashSet());
        this.executeInParallelBatches(changedPaths, uniformPaths -> {
            TokenElementIndexCache tokenElementCache = this.createTokenElementCache((List<String>)uniformPaths);
            uniformPaths = CloneSynchronizer.filterPathsByLanguage(uniformPaths, tokenElementCache);
            Collection<CloneClass> cloneClasses = this.synchronizeClones((List<String>)uniformPaths, tokenElementCache, minCloneLength, allowGaps, cloneClassSizeLimit);
            allOtherPathsAffectedByClones.addAll(CloneAnalysisUtils.getCloneUniformPaths(cloneClasses));
        });
        CollectionUtils.removeAll(allOtherPathsAffectedByClones, changedPaths);
        ArrayList paths = new ArrayList(allOtherPathsAffectedByClones);
        this.executeInParallelBatches(paths, uniformPaths -> {
            TokenElementIndexCache tokenElementCache = this.createTokenElementCache((List<String>)uniformPaths);
            uniformPaths = CloneSynchronizer.filterPathsByLanguage(uniformPaths, tokenElementCache);
            this.synchronizeClones((List<String>)uniformPaths, tokenElementCache, minCloneLength, allowGaps, cloneClassSizeLimit);
        });
    }

    private boolean initComponentHelper() {
        if (!this.resultSynchronizer.reportCrossOrIntraComponentClones()) {
            return true;
        }
        try {
            this.componentHelper = CloneComponentHelper.fromArchitecturePath(this.contentIndex, this.resultSynchronizer.getCrossComponentClonesArchitectureFile(), this.getParallelTaskExecutor());
        }
        catch (ConQATException e) {
            if (this.resultSynchronizer.useExclusiveIntraComponentDetection()) {
                LOGGER.warn("Exclusive intra-component clone detection is enabled but the cross-component architecture definition cannot be loaded. In these circumstances, the clone detection cannot produce meaningful results. The detection will start to work once the cross-component architecture becomes available.", (Throwable)e);
                return false;
            }
            LOGGER.error("Could not load cross-component architecture definition. All clones will be reported as intra-component clones.", (Throwable)e);
        }
        return true;
    }

    @Contract(value="_ -> new")
    private @NonNull TokenElementIndexCache createTokenElementCache(@NonNull List<String> uniformPaths) throws StorageException {
        return new TokenElementIndexCache(this.contentIndex, UniformPathCompatibilityUtil.convertCollection(uniformPaths));
    }

    private @NonNull List<String> determineChangedPaths() throws StorageException {
        boolean architectureChanged = false;
        HashSet<String> changedPaths = new HashSet<String>();
        if (this.resultSynchronizer.reportCrossOrIntraComponentClones() && this.contentDelta.getAddedOrChangedKeysAsStrings().contains(this.resultSynchronizer.getCrossComponentClonesArchitectureFile())) {
            architectureChanged = true;
            LOGGER.info("Cross-component clone architecture file was changed. Rerunning detection on all files.");
            List<String> allRelevantPaths = this.filterPathsByPathOnly(this.contentIndex.getAllUniformPaths());
            changedPaths.addAll(allRelevantPaths);
            changedPaths.addAll(this.resultSynchronizer.getPathsOfChangedCloneClasses(allRelevantPaths));
        } else {
            changedPaths.addAll(this.filterPathsByPathOnly(this.contentDelta.getAddedOrChangedKeysAsStrings()));
            changedPaths.addAll(this.resultSynchronizer.getPathsOfChangedCloneClasses(this.contentDelta.getAllKeysAsStrings()));
        }
        CollectionUtils.removeAll(changedPaths, (List)this.contentDelta.getDeletedKeysAsStrings());
        ArrayList<String> pathsAsList = new ArrayList<String>(changedPaths);
        if (this.resultSynchronizer.useExclusiveIntraComponentDetection() && architectureChanged) {
            this.resultSynchronizer.persistDeletions(pathsAsList);
        }
        return pathsAsList;
    }

    private @NonNull List<String> filterPathsByPathOnly(@NonNull List<String> paths) {
        return CollectionUtils.filter(paths, path -> CloneAnalysisUtils.isNonIgnoredPath(path, this.compiledIgnoredUniformPathPatterns));
    }

    private static @NonNull List<String> filterPathsByLanguage(@NonNull List<String> paths, @NonNull TokenElementIndexCache tokenElementCache) {
        return CollectionUtils.filter(paths, path -> CloneAnalysisUtils.isNonIgnoredLanguage(CloneSynchronizer.getLanguageForPath(path, tokenElementCache)));
    }

    private static @Nullable ELanguage getLanguageForPath(@NonNull String path, @NonNull TokenElementIndexCache tokenElementCache) {
        try {
            TokenElementInfo element = tokenElementCache.getTokenElementInfo(UniformPathCompatibilityUtil.convert((String)path));
            if (element != null) {
                return element.getLanguage();
            }
        }
        catch (StorageException e) {
            LOGGER.warn("Could not load TokenElementInfo for '{}'", (Object)path, (Object)e);
        }
        return null;
    }

    private Collection<CloneClass> synchronizeClones(List<String> uniformPaths, TokenElementIndexCache tokenElementCache, int minCloneLength, boolean allowGaps, int cloneClassSizeLimit) throws StorageException {
        Collection<CloneClass> cloneClasses = this.getCloneClasses(uniformPaths, minCloneLength, allowGaps, cloneClassSizeLimit);
        Set<String> cloneUniformPaths = CloneAnalysisUtils.getCloneUniformPaths(cloneClasses);
        Map<String, TokenElementInfo> uniformPathToElement = this.loadTokenElements(uniformPaths, cloneUniformPaths, tokenElementCache);
        CloneSynchronizer.removeClonesWithoutTokenElement(cloneClasses, uniformPathToElement);
        cloneClasses = new UnitAwareCloneClassFilter(minCloneLength, CloneSynchronizer.getPreAstAlignmentConstraints(allowGaps)).filterCloneClasses(cloneClasses, uniformPathToElement);
        if (!this.includeClosedSpecItems && cloneUniformPaths.stream().anyMatch(WiaUtils::isWorkItemPath)) {
            cloneClasses = CloneSynchronizer.removeClonesForClosedSpecItems(cloneClasses, uniformPathToElement);
        }
        CloneClassAndUnitCountUpdater updater = new CloneClassAndUnitCountUpdater(minCloneLength, allowGaps, this.resultSynchronizer.useExclusiveIntraComponentDetection(), cloneClasses, uniformPathToElement);
        updater.computeCloneClassesAndUnitCounts();
        cloneClasses = updater.getCloneClasses();
        cloneClasses = new UnitAwareCloneClassFilter(minCloneLength, Collections.singletonList(new MinimalOverlappingConstraint(minCloneLength))).filterCloneClasses(cloneClasses, uniformPathToElement);
        Map<String, CodeScopeName> pathToCodeScope = uniformPathToElement.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> CodeScopeDetail.getCodeScopeNameFromTokenElement((BasicTokenElementInfo)e.getValue())));
        List<String> filteredPaths = uniformPaths.stream().filter(uniformPathToElement::containsKey).toList();
        this.resultSynchronizer.persistDetectionResults(filteredPaths, cloneClasses, updater.getUniformPathToUnitCount(), this.componentHelper, pathToCodeScope, this.allowCodeGaps || this.allowSpecItemGaps);
        return cloneClasses;
    }

    private static Collection<CloneClass> removeClonesForClosedSpecItems(Collection<CloneClass> cloneClasses, Map<String, TokenElementInfo> uniformPathToElement) {
        for (CloneClass cloneClass2 : cloneClasses) {
            if (!WiaUtils.isWorkItemPath((String)((Clone)CollectionUtils.getAny(cloneClass2.getClones())).getUniformPath())) continue;
            HashSet<Clone> clonesToRemove = new HashSet<Clone>();
            for (Clone clone : cloneClass2.getClones()) {
                TokenElementInfo elementInfo = uniformPathToElement.get(clone.getUniformPath());
                if (!((Boolean)WiaTokenUtils.isItemClosed(elementInfo.getTokens()).orElseThrow()).booleanValue()) continue;
                clonesToRemove.add(clone);
            }
            clonesToRemove.forEach(cloneClass2::remove);
        }
        return cloneClasses.stream().filter(cloneClass -> cloneClass.size() >= 2).toList();
    }

    private static void removeClonesWithoutTokenElement(Collection<CloneClass> cloneClasses, Map<String, TokenElementInfo> uniformPathToElement) {
        for (CloneClass cloneClass : cloneClasses) {
            HashSet<Clone> clonesToRemove = new HashSet<Clone>();
            for (Clone clone : cloneClass.getClones()) {
                if (uniformPathToElement.containsKey(clone.getUniformPath())) continue;
                Supplier[] supplierArray = new Supplier[2];
                supplierArray[0] = cloneClass::toString;
                supplierArray[1] = clone::getLocation;
                LOGGER.error("Encountered clone class '{}' which contains clone '{}' for which no token element is present. Removing clone.", supplierArray);
                clonesToRemove.add(clone);
            }
            for (Clone clone : clonesToRemove) {
                cloneClass.remove(clone);
            }
        }
    }

    private Map<String, TokenElementInfo> loadTokenElements(List<String> uniformPaths, Set<String> cloneUniformPaths, TokenElementIndexCache tokenElementCache) throws StorageException {
        ArrayList uniformPathsToLoad = new ArrayList(CollectionUtils.unionSet(cloneUniformPaths, (Collection[])new Collection[]{uniformPaths}));
        List<TokenElementInfo> elements = tokenElementCache.getTokenElementInfos(UniformPathCompatibilityUtil.convertCollection(uniformPathsToLoad));
        HashMap<String, TokenElementInfo> uniformPathToElement = HashMap.newHashMap(uniformPathsToLoad.size());
        for (int i = 0; i < uniformPathsToLoad.size(); ++i) {
            String uniformPath = (String)uniformPathsToLoad.get(i);
            TokenElementInfo element = elements.get(i);
            if (element == null) {
                LOGGER.error("Missing element for path '{}' which was {}", (Object)uniformPath, (Object)StringUtils.alternativeOnCondition((boolean)uniformPaths.contains(uniformPath), (String)"contained in delta", (String)"derived from clone classes"));
                continue;
            }
            if (!CloneAnalysisUtils.isNonIgnoredElement(element, this.cloneDetectionEnablement, this.compiledIgnoredUniformPathPatterns)) continue;
            uniformPathToElement.put(uniformPath, element);
        }
        return uniformPathToElement;
    }

    private @NonNull Collection<CloneClass> getCloneClasses(List<String> uniformPaths, int minCloneLength, boolean allowGaps, int cloneClassSizeLimit) throws StorageException {
        SizeFilteringCollectingCloneClassReporter collector = new SizeFilteringCollectingCloneClassReporter(cloneClassSizeLimit);
        CloneDetector cloneDetector = new CloneDetector(this.byPathChunkIndex, this.byHashChunkIndex);
        if (this.resultSynchronizer.useExclusiveIntraComponentDetection()) {
            Verify.verifyNotNull((Object)this.componentHelper, (String)"Exclusive intra-component clone detection is enabled but architecture information is not available. This is probably a configuration error. Please check the log for earlier errors.", (Object[])new Object[0]);
            cloneDetector.reportIntraComponentClones(uniformPaths, this.componentHelper, collector, minCloneLength);
            CloneComponentHelper.checkIntraComponentCloneClassConsistency(collector.getCloneClasses(), LOGGER);
        } else {
            cloneDetector.reportClones(uniformPaths, collector, minCloneLength, allowGaps);
        }
        return collector.getCloneClasses();
    }

    private static @NonNull List<ICloneClassConstraint> getPreAstAlignmentConstraints(boolean allowGaps) {
        ArrayList<ICloneClassConstraint> constraints = new ArrayList<ICloneClassConstraint>();
        if (!allowGaps) {
            constraints.add(new SimilarityConstraint());
        }
        return constraints;
    }
}

